/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.util.List;
import java.util.StringTokenizer;
import org.apache.wicket.core.request.mapper.AbstractResourceReferenceMapper;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.MetaInfStaticResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.ResourceReferenceRegistry;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.request.resource.caching.ResourceUrl;
import org.apache.wicket.resource.ResourceUtil;
import org.apache.wicket.resource.bundles.ResourceBundleReference;
import org.apache.wicket.util.IProvider;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicResourceReferenceMapper
extends AbstractResourceReferenceMapper {
    private static final Logger log = LoggerFactory.getLogger(BasicResourceReferenceMapper.class);
    protected final IPageParametersEncoder pageParametersEncoder;
    protected final IProvider<? extends IResourceCachingStrategy> cachingStrategy;

    public BasicResourceReferenceMapper(IPageParametersEncoder pageParametersEncoder, IProvider<? extends IResourceCachingStrategy> cachingStrategy) {
        this.pageParametersEncoder = (IPageParametersEncoder)Args.notNull((Object)pageParametersEncoder, (String)"pageParametersEncoder");
        this.cachingStrategy = cachingStrategy;
    }

    public IRequestHandler mapRequest(Request request) {
        Url url = request.getUrl();
        if (this.canBeHandled(url)) {
            ResourceReference res;
            int segmentsSize = url.getSegments().size();
            PageParameters pageParameters = this.extractPageParameters(request, segmentsSize, this.pageParametersEncoder);
            String className = (String)url.getSegments().get(2);
            StringBuilder name = new StringBuilder(segmentsSize * 2);
            for (int i = 3; i < segmentsSize; ++i) {
                String segment = (String)url.getSegments().get(i);
                if (segment.indexOf(47) > -1) {
                    return null;
                }
                if (i + 1 == segmentsSize && !Strings.isEmpty((CharSequence)segment)) {
                    ResourceUrl resourceUrl = new ResourceUrl(segment, (INamedParameters)pageParameters);
                    this.getCachingStrategy().undecorateUrl(resourceUrl);
                    segment = resourceUrl.getFileName();
                    Checks.notEmpty((String)segment, (String)"Caching strategy returned empty name for '%s'", (Object[])new Object[]{resourceUrl});
                }
                if (name.length() > 0) {
                    name.append('/');
                }
                name.append(segment);
            }
            ResourceReference.UrlAttributes attributes = ResourceUtil.decodeResourceReferenceAttributes(url);
            Class<?> scope = this.resolveClass(className);
            if (scope != null && scope.getPackage() != null && (res = this.getContext().getResourceReferenceRegistry().getResourceReference(scope, name.toString(), attributes.getLocale(), attributes.getStyle(), attributes.getVariation(), true, true)) != null) {
                return new ResourceReferenceRequestHandler(res, pageParameters);
            }
        }
        return null;
    }

    protected final IResourceCachingStrategy getCachingStrategy() {
        return (IResourceCachingStrategy)this.cachingStrategy.get();
    }

    protected Class<?> resolveClass(String name) {
        return WicketObjects.resolveClass(name);
    }

    protected String getClassName(Class<?> scope) {
        return scope.getName();
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        if (requestHandler instanceof ResourceReferenceRequestHandler) {
            Url url;
            ResourceReferenceRequestHandler referenceRequestHandler = (ResourceReferenceRequestHandler)requestHandler;
            ResourceReference reference = referenceRequestHandler.getResourceReference();
            while (reference instanceof ResourceBundleReference) {
                reference = ((ResourceBundleReference)reference).getBundleReference();
            }
            if (reference instanceof MetaInfStaticResourceReference && (url = ((MetaInfStaticResourceReference)reference).mapHandler(referenceRequestHandler)) != null) {
                return url;
            }
            if (reference.canBeRegistered()) {
                ResourceReferenceRegistry resourceReferenceRegistry = this.getContext().getResourceReferenceRegistry();
                resourceReferenceRegistry.registerResourceReference(reference);
            }
            url = new Url();
            List segments = url.getSegments();
            segments.add(this.getContext().getNamespace());
            segments.add(this.getContext().getResourceIdentifier());
            segments.add(this.getClassName(reference.getScope()));
            PageParameters parameters = referenceRequestHandler.getPageParameters();
            if (parameters == null) {
                parameters = new PageParameters();
            } else {
                parameters = new PageParameters(parameters);
                parameters.clearIndexed();
            }
            ResourceUtil.encodeResourceReferenceAttributes(url, reference);
            StringTokenizer tokens = new StringTokenizer(reference.getName(), "/");
            while (tokens.hasMoreTokens()) {
                IStaticCacheableResource cacheable;
                IResource resource;
                String token = tokens.nextToken();
                if (!tokens.hasMoreTokens() && !Strings.isEmpty((CharSequence)token) && (resource = reference.getResource()) instanceof IStaticCacheableResource && (cacheable = (IStaticCacheableResource)resource).isCachingEnabled()) {
                    ResourceUrl resourceUrl = new ResourceUrl(token, (INamedParameters)parameters);
                    this.getCachingStrategy().decorateUrl(resourceUrl, cacheable);
                    token = resourceUrl.getFileName();
                    Checks.notEmpty((String)token, (String)"Caching strategy returned empty name for '%s'", (Object[])new Object[]{resource});
                }
                segments.add(token);
            }
            if (!parameters.isEmpty()) {
                url = this.encodePageParameters(url, parameters, this.pageParametersEncoder);
            }
            return url;
        }
        return null;
    }

    public int getCompatibilityScore(Request request) {
        Url url = request.getUrl();
        int score = -1;
        if (this.canBeHandled(url)) {
            score = 1;
        }
        return score;
    }

    protected boolean canBeHandled(Url url) {
        List segments = url.getSegments();
        return segments.size() >= 4 && this.urlStartsWith(url, new String[]{this.getContext().getNamespace(), this.getContext().getResourceIdentifier()}) && !Strings.isEmpty((CharSequence)((CharSequence)segments.get(3)));
    }
}

