/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.checker;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDAbstractDateTimeType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDBaseNumericType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDDouble;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDFloat;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.checker.NodeChecker;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationState;

public class CheckerLiterals
implements NodeChecker {
    public static boolean WarnOnBadLiterals = true;
    private ErrorHandler handler;
    private static final Pattern langPattern = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");

    public CheckerLiterals(ErrorHandler handler) {
        this.handler = handler;
    }

    @Override
    public boolean check(Node node, long line, long col) {
        return node.isLiteral() && CheckerLiterals.checkLiteral(node, this.handler, line, col);
    }

    public static boolean checkLiteral(Node node, ErrorHandler handler, long line, long col) {
        if (!node.isLiteral()) {
            handler.error("Not a literal: " + node, line, col);
            return false;
        }
        return CheckerLiterals.checkLiteral(node.getLiteralLexicalForm(), node.getLiteralLanguage(), node.getLiteralDatatype(), handler, line, col);
    }

    public static boolean checkLiteral(String lexicalForm, RDFDatatype datatype, ErrorHandler handler, long line, long col) {
        return CheckerLiterals.checkLiteral(lexicalForm, null, datatype, handler, line, col);
    }

    public static boolean checkLiteral(String lexicalForm, String lang, ErrorHandler handler, long line, long col) {
        return CheckerLiterals.checkLiteral(lexicalForm, lang, null, handler, line, col);
    }

    public static boolean checkLiteral(String lexicalForm, String lang, RDFDatatype datatype, ErrorHandler handler, long line, long col) {
        boolean hasLang;
        if (!WarnOnBadLiterals) {
            return true;
        }
        boolean bl = hasLang = lang != null && !lang.equals("");
        if (!hasLang) {
            if (datatype != null) {
                return CheckerLiterals.validateByDatatype(lexicalForm, datatype, handler, line, col);
            }
            return true;
        }
        if (JenaRuntime.isRDF11) {
            if (datatype != null && !Objects.equals(datatype.getURI(), NodeConst.rdfLangString.getURI())) {
                handler.error("Literal has language but wrong datatype", line, col);
                return false;
            }
        } else if (datatype != null) {
            handler.error("Literal has datatype and language", line, col);
            return false;
        }
        if (!lang.isEmpty() && !langPattern.matcher(lang).matches()) {
            handler.warning("Language not valid: " + lang, line, col);
            return false;
        }
        return true;
    }

    protected static boolean validateByDatatype(String lexicalForm, RDFDatatype datatype, ErrorHandler handler, long line, long col) {
        if (SysRIOT.StrictXSDLexicialForms) {
            if (datatype instanceof XSDBaseNumericType || datatype instanceof XSDFloat || datatype instanceof XSDDouble) {
                return CheckerLiterals.validateByDatatypeNumeric(lexicalForm, datatype, handler, line, col);
            }
            if (datatype instanceof XSDAbstractDateTimeType) {
                return CheckerLiterals.validateByDatatypeDateTime(lexicalForm, datatype, handler, line, col);
            }
        }
        return CheckerLiterals.validateByDatatypeJena(lexicalForm, datatype, handler, line, col);
    }

    protected static boolean validateByDatatypeJena(String lexicalForm, RDFDatatype datatype, ErrorHandler handler, long line, long col) {
        if (datatype.isValid(lexicalForm)) {
            return true;
        }
        handler.warning("Lexical form '" + lexicalForm + "' not valid for datatype " + datatype.getURI(), line, col);
        return false;
    }

    protected static boolean validateByDatatypeDateTime(String lexicalForm, RDFDatatype datatype, ErrorHandler handler, long line, long col) {
        if (lexicalForm.contains(" ")) {
            handler.warning("Whitespace in XSD date or time literal: '" + lexicalForm + "'", line, col);
            return false;
        }
        if (lexicalForm.contains("\n")) {
            handler.warning("Newline in XSD date or time literal: '" + lexicalForm + "'", line, col);
            return false;
        }
        if (lexicalForm.contains("\r")) {
            handler.warning("Newline in XSD date or time literal: '" + lexicalForm + "'", line, col);
            return false;
        }
        return CheckerLiterals.validateByDatatypeJena(lexicalForm, datatype, handler, line, col);
    }

    protected static boolean validateByDatatypeNumeric(String lexicalForm, RDFDatatype datatype, ErrorHandler handler, long line, long col) {
        if (lexicalForm.contains(" ")) {
            handler.warning("Whitespace in numeric XSD literal: '" + lexicalForm + "'", line, col);
            return false;
        }
        if (lexicalForm.contains("\n")) {
            handler.warning("Newline in numeric XSD literal: '" + lexicalForm + "'", line, col);
            return false;
        }
        if (lexicalForm.contains("\r")) {
            handler.warning("Carriage return in numeric XSD literal: '" + lexicalForm + "'", line, col);
            return false;
        }
        if (!SysRIOT.StrictXSDLexicialForms) {
            return CheckerLiterals.validateByDatatypeJena(lexicalForm, datatype, handler, line, col);
        }
        XSSimpleType typeDeclaration = (XSSimpleType)datatype.extendedTypeDefinition();
        try {
            ValidationState context = new ValidationState();
            ValidatedInfo resultInfo = new ValidatedInfo();
            Object result = typeDeclaration.validate(lexicalForm, (ValidationContext)context, resultInfo);
            return true;
        }
        catch (InvalidDatatypeValueException e2) {
            handler.warning("Lexical form '" + lexicalForm + "' not valid for datatype " + datatype.getURI(), line, col);
            return false;
        }
    }
}

