/*
 * Copyright 2006 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.user.client.ui.impl;

import com.google.gwt.user.client.Element;

/**
 * Opera implementation of
 * {@link com.google.gwt.user.client.ui.impl.FormPanelImpl}.
 */
public class FormPanelImplOpera extends FormPanelImpl {

  public native String getTextContents(Element iframe) /*-{
    try {
      // Make sure the iframe's document is loaded.
      if (!iframe.contentWindow.document)
        return null;
  
      // Opera puts the raw text in a <pre> element. InnerText gets around this.
      return iframe.contentWindow.document.body.innerText;
    } catch (e) {
      return null;
    }
  }-*/;
}
