/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Quota {
    private Integer id;
    @NotEmpty
    @NotNull
    @Pattern(regexp="quota")
    private @NotEmpty @NotNull @Pattern(regexp="quota") String object;
    @NotEmpty
    @Pattern(regexp="portal|storage|repository_storage")
    @NotNull
    private @NotEmpty @Pattern(regexp="portal|storage|repository_storage") @NotNull String quotaType;
    @NotNull
    private Double softLimit;
    @NotNull
    private Double hardLimit;
    @NotNull
    private Double totalUsage;
    @NotEmpty
    @NotNull
    private String unit;
    private Integer orderId;
    private String subject;
    private String name;

    public Quota() {
    }

    public Quota(String json) throws IOException {
        if (!json.equals("{}")) {
            Quota quota = (Quota)new ObjectMapper().readValue(json, Quota.class);
            this.id = quota.id;
            this.object = quota.object;
            this.quotaType = quota.quotaType;
            this.softLimit = quota.softLimit;
            this.hardLimit = quota.hardLimit;
            this.totalUsage = quota.totalUsage;
            this.unit = quota.unit;
            this.orderId = quota.orderId;
            this.subject = quota.subject;
            this.name = quota.name;
        }
    }

    public Quota(Integer id, @NotNull @NotEmpty String object, @NotNull @NotEmpty String quotaType, @NotNull Double softLimit, @NotNull Double hardLimit, @NotNull Double totalUsage, @NotNull @NotEmpty String unit, Integer orderId, String subject, String name) {
        if (id != null && !id.toString().equals("")) {
            this.id = id;
        }
        this.object = object;
        this.quotaType = quotaType;
        this.softLimit = softLimit;
        this.hardLimit = hardLimit;
        this.unit = unit;
        this.totalUsage = totalUsage;
        this.orderId = orderId;
        this.subject = subject;
        this.name = name;
    }

    @JsonProperty
    public Integer getId() {
        return this.id;
    }

    @JsonProperty
    public void setId(Integer id) {
        this.id = id;
    }

    @JsonProperty
    public String getObject() {
        return this.object;
    }

    @JsonProperty
    public void setObject(String object) {
        this.object = object;
    }

    @JsonProperty
    public String getQuotaType() {
        return this.quotaType;
    }

    @JsonProperty
    public void setQuotaType(String quotaType) {
        this.quotaType = quotaType;
    }

    @JsonProperty
    @NotNull
    public Double getSoftLimit() {
        return this.softLimit;
    }

    @JsonProperty
    public void setSoftLimit(@NotNull Double softLimit) {
        this.softLimit = softLimit;
    }

    @JsonProperty
    @NotNull
    public Double getHardLimit() {
        return this.hardLimit;
    }

    @JsonProperty
    public void setHardLimit(@NotNull Double hardLimit) {
        this.hardLimit = hardLimit;
    }

    @JsonProperty
    public Double getTotalUsage() {
        if (this.totalUsage == null) {
            this.totalUsage = 0.0;
        }
        return this.totalUsage;
    }

    @JsonProperty
    public void setTotalUsage(Double totalUsage) {
        this.totalUsage = totalUsage;
    }

    @JsonProperty
    public String getUnit() {
        return this.unit;
    }

    @JsonProperty
    public void setUnit(String unit) {
        this.unit = unit;
    }

    @JsonProperty
    public Integer getOrderId() {
        return this.orderId;
    }

    @JsonProperty
    public void setOrderId(Integer orderId) {
        this.orderId = orderId;
    }

    @JsonProperty
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quota quota = (Quota)o;
        return Objects.equals(this.getId(), quota.getId()) && this.getObject().equals(quota.getObject()) && this.getQuotaType().equals(quota.getQuotaType()) && this.getSoftLimit().equals(quota.getSoftLimit()) && this.getHardLimit().equals(quota.getHardLimit()) && Objects.equals(this.getTotalUsage(), quota.getTotalUsage()) && this.getUnit().equals(quota.getUnit()) && Objects.equals(this.getOrderId(), quota.getOrderId()) && Objects.equals(this.getSubject(), quota.getSubject()) && Objects.equals(this.getName(), quota.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getObject(), this.getQuotaType(), this.getSoftLimit(), this.getHardLimit(), this.getTotalUsage(), this.getUnit(), this.getOrderId(), this.getSubject(), this.getName());
    }
}

