/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.awt.Color;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public class ColorConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        if (target.equals(Color.class)) {
            if (source.equals(String.class)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        String rgba = (String)source;
                        try {
                            return Color.decode(rgba);
                        }
                        catch (NumberFormatException badRGB) {
                            return null;
                        }
                    }
                };
            }
            if (source.equals(Integer.class)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Integer rgba = (Integer)source;
                        int alpha = 0xFF000000 & rgba;
                        return new Color(rgba, alpha != 0);
                    }
                };
            }
        } else if (target.equals(String.class) && source.equals(Color.class)) {
            return new Converter(){

                public <T> T convert(Object source, Class<T> target) throws Exception {
                    Color color = (Color)source;
                    String redCode = Integer.toHexString(color.getRed());
                    String greenCode = Integer.toHexString(color.getGreen());
                    String blueCode = Integer.toHexString(color.getBlue());
                    if (redCode.length() == 1) {
                        redCode = "0" + redCode;
                    }
                    if (greenCode.length() == 1) {
                        greenCode = "0" + greenCode;
                    }
                    if (blueCode.length() == 1) {
                        blueCode = "0" + blueCode;
                    }
                    return (T)("#" + redCode + greenCode + blueCode).toUpperCase();
                }
            };
        }
        return null;
    }
}

