/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer.validate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.buffer.validate.BufferDistanceValidator;

public class BufferResultValidator {
    private static boolean VERBOSE = false;
    private static final double MAX_ENV_DIFF_FRAC = 0.012;
    private Geometry input;
    private double distance;
    private Geometry result;
    private boolean isValid = true;
    private String errorMsg = null;
    private Coordinate errorLocation = null;

    public static boolean isValid(Geometry g, double distance, Geometry result) {
        BufferResultValidator validator = new BufferResultValidator(g, distance, result);
        return validator.isValid();
    }

    public static String isValidMsg(Geometry g, double distance, Geometry result) {
        BufferResultValidator validator = new BufferResultValidator(g, distance, result);
        if (!validator.isValid()) {
            return validator.getErrorMessage();
        }
        return null;
    }

    public BufferResultValidator(Geometry input, double distance, Geometry result) {
        this.input = input;
        this.distance = distance;
        this.result = result;
    }

    public boolean isValid() {
        this.checkPolygonal();
        if (!this.isValid) {
            return this.isValid;
        }
        this.checkExpectedEmpty();
        if (!this.isValid) {
            return this.isValid;
        }
        this.checkEnvelope();
        if (!this.isValid) {
            return this.isValid;
        }
        this.checkArea();
        if (!this.isValid) {
            return this.isValid;
        }
        this.checkDistance();
        return this.isValid;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public Coordinate getErrorLocation() {
        return this.errorLocation;
    }

    private void report(String checkName) {
        if (!VERBOSE) {
            return;
        }
        System.out.println("Check " + checkName + ": " + (this.isValid ? "passed" : "FAILED"));
    }

    private void checkPolygonal() {
        if (!(this.result instanceof Polygon) && !(this.result instanceof MultiPolygon)) {
            this.isValid = false;
        }
        this.errorMsg = "Result is not polygonal";
        this.report("Polygonal");
    }

    private void checkExpectedEmpty() {
        if (this.input.getDimension() >= 2) {
            return;
        }
        if (this.distance > 0.0) {
            return;
        }
        if (!this.result.isEmpty()) {
            this.isValid = false;
            this.errorMsg = "Result is non-empty";
        }
        this.report("ExpectedEmpty");
    }

    private void checkEnvelope() {
        if (this.distance < 0.0) {
            return;
        }
        double padding = this.distance * 0.012;
        if (padding == 0.0) {
            padding = 0.001;
        }
        Envelope expectedEnv = new Envelope(this.input.getEnvelopeInternal());
        expectedEnv.expandBy(this.distance);
        Envelope bufEnv = new Envelope(this.result.getEnvelopeInternal());
        bufEnv.expandBy(padding);
        if (!bufEnv.contains(expectedEnv)) {
            this.isValid = false;
            this.errorMsg = "Buffer envelope is incorrect";
        }
        this.report("Envelope");
    }

    private void checkArea() {
        double inputArea = this.input.getArea();
        double resultArea = this.result.getArea();
        if (this.distance > 0.0 && inputArea > resultArea) {
            this.isValid = false;
            this.errorMsg = "Area of positive buffer is smaller than input";
        }
        if (this.distance < 0.0 && inputArea < resultArea) {
            this.isValid = false;
            this.errorMsg = "Area of negative buffer is larger than input";
        }
        this.report("Area");
    }

    private void checkDistance() {
        BufferDistanceValidator distValid = new BufferDistanceValidator(this.input, this.distance, this.result);
        if (!distValid.isValid()) {
            this.isValid = false;
            this.errorMsg = distValid.getErrorMessage();
            this.errorLocation = distValid.getErrorLocation();
        }
        this.report("Distance");
    }
}

