/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4;

import com.carrotsearch.ant.tasks.junit4.TestsSummary;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Subscribe;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedSuiteResultEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedTestResultEvent;

public class TestsSummaryEventListener {
    private int failures;
    private int tests;
    private int errors;
    private int assumptions;
    private int ignores;
    private int suites;
    private int ignoredSuites;
    private int suiteErrors;

    @Subscribe
    public void suiteSummary(AggregatedSuiteResultEvent aggregatedSuiteResultEvent) {
        ++this.suites;
        if (!aggregatedSuiteResultEvent.getFailures().isEmpty()) {
            this.suiteErrors += aggregatedSuiteResultEvent.getFailures().size();
        }
        for (AggregatedTestResultEvent aggregatedTestResultEvent : aggregatedSuiteResultEvent.getTests()) {
            ++this.tests;
            switch (aggregatedTestResultEvent.getStatus()) {
                case ERROR: {
                    ++this.errors;
                    break;
                }
                case FAILURE: {
                    ++this.failures;
                    break;
                }
                case IGNORED: {
                    ++this.ignores;
                    break;
                }
                case IGNORED_ASSUMPTION: {
                    ++this.assumptions;
                    break;
                }
            }
        }
        if (aggregatedSuiteResultEvent.isSuccessful() && aggregatedSuiteResultEvent.getTests().isEmpty()) {
            ++this.ignoredSuites;
        }
    }

    public TestsSummary getResult() {
        return new TestsSummary(this.suites, this.ignoredSuites, this.suiteErrors, this.tests, this.failures, this.errors, this.assumptions, this.ignores);
    }
}

