/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.verb;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.NoSetHierarchyException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.server.verb.ServerVerb;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;

public class ListSets
extends ServerVerb {
    private static ArrayList validParamNames = new ArrayList();
    private static ArrayList requiredParamNames;

    public static String construct(HashMap context, HttpServletRequest request, HttpServletResponse response, Transformer serverTransformer) throws OAIInternalServerError, TransformerException {
        Properties properties = (Properties)context.get("OAIHandler.properties");
        AbstractCatalog abstractCatalog = (AbstractCatalog)context.get("OAIHandler.catalog");
        String baseURL = properties.getProperty("OAIHandler.baseURL");
        if (baseURL == null) {
            try {
                baseURL = request.getRequestURL().toString();
            }
            catch (NoSuchMethodError f) {
                baseURL = HttpUtils.getRequestURL((HttpServletRequest)request).toString();
            }
        }
        StringBuffer sb = new StringBuffer();
        String oldResumptionToken = request.getParameter("resumptionToken");
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        String styleSheet = properties.getProperty("OAIHandler.styleSheet");
        if (styleSheet != null) {
            sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"");
            sb.append(styleSheet);
            sb.append("\"?>");
        }
        sb.append("<OAI-PMH xmlns=\"http://www.openarchives.org/OAI/2.0/\"");
        sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        sb.append(" xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/");
        sb.append(" http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd\">");
        sb.append("<responseDate>");
        sb.append(ServerVerb.createResponseDate(new Date()));
        sb.append("</responseDate>");
        sb.append(ServerVerb.getRequestElement(request, validParamNames, baseURL));
        Map listSetsMap = null;
        if (ServerVerb.hasBadArguments(request, requiredParamNames.iterator(), validParamNames)) {
            sb.append(new BadArgumentException().getMessage());
        } else {
            try {
                listSetsMap = oldResumptionToken == null ? abstractCatalog.listSets() : abstractCatalog.listSets(oldResumptionToken);
                sb.append("<ListSets>");
                Iterator sets = (Iterator)listSetsMap.get("sets");
                while (sets.hasNext()) {
                    sb.append((String)sets.next());
                }
                Map newResumptionMap = (Map)listSetsMap.get("resumptionMap");
                if (newResumptionMap != null) {
                    String newResumptionToken = (String)newResumptionMap.get("resumptionToken");
                    String expirationDate = (String)newResumptionMap.get("expirationDate");
                    String completeListSize = (String)newResumptionMap.get("completeListSize");
                    String cursor = (String)newResumptionMap.get("cursor");
                    sb.append("<resumptionToken");
                    if (expirationDate != null) {
                        sb.append(" expirationDate=\"");
                        sb.append(expirationDate);
                        sb.append("\"");
                    }
                    if (completeListSize != null) {
                        sb.append(" completeListSize=\"");
                        sb.append(completeListSize);
                        sb.append("\"");
                    }
                    if (cursor != null) {
                        sb.append(" cursor=\"");
                        sb.append(cursor);
                        sb.append("\"");
                    }
                    sb.append(">");
                    sb.append(newResumptionToken);
                    sb.append("</resumptionToken>");
                } else if (oldResumptionToken != null) {
                    sb.append("<resumptionToken />");
                }
                sb.append("</ListSets>");
            }
            catch (NoSetHierarchyException e) {
                sb.append(e.getMessage());
            }
            catch (BadResumptionTokenException e) {
                sb.append(e.getMessage());
            }
        }
        sb.append("</OAI-PMH>");
        return ServerVerb.render(response, "text/xml; charset=UTF-8", sb.toString(), serverTransformer);
    }

    static {
        validParamNames.add("verb");
        validParamNames.add("resumptionToken");
        requiredParamNames = new ArrayList();
        validParamNames.add("verb");
    }
}

