/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client.httpclient4;

import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.client.httpclient4.OAuthCredentials;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.message.BasicHeader;

class OAuthScheme
extends RFC2617Scheme {
    private final String defaultRealm;
    private boolean complete;

    OAuthScheme(String defaultRealm) {
        this.defaultRealm = defaultRealm;
    }

    public String getRealm() {
        String realm = super.getRealm();
        if (realm == null) {
            realm = this.defaultRealm;
        }
        return realm;
    }

    public String getSchemeName() {
        return "OAuth";
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isConnectionBased() {
        return false;
    }

    public void processChallenge(Header challenge) throws MalformedChallengeException {
        super.processChallenge(challenge);
        this.complete = true;
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        String method;
        String uri;
        HttpUriRequest uriRequest = this.getHttpUriRequest(request);
        if (uriRequest != null) {
            uri = uriRequest.getURI().toString();
            method = uriRequest.getMethod();
        } else {
            RequestLine requestLine = request.getRequestLine();
            uri = requestLine.getUri();
            method = requestLine.getMethod();
        }
        try {
            OAuthMessage message = new OAuthMessage(method, uri, null);
            OAuthAccessor accessor = this.getAccessor(credentials);
            message.addRequiredParameters(accessor);
            String authorization = message.getAuthorizationHeader(this.getRealm());
            return new BasicHeader("Authorization", authorization);
        }
        catch (Exception e) {
            throw new AuthenticationException(null, (Throwable)e);
        }
    }

    private HttpUriRequest getHttpUriRequest(HttpRequest request) {
        HttpRequest original;
        while (request instanceof RequestWrapper && (original = ((RequestWrapper)request).getOriginal()) != request) {
            request = original;
        }
        if (request instanceof HttpUriRequest) {
            return (HttpUriRequest)request;
        }
        return null;
    }

    private OAuthAccessor getAccessor(Credentials credentials) {
        if (credentials instanceof OAuthCredentials) {
            return ((OAuthCredentials)credentials).getAccessor();
        }
        return new OAuthAccessor(new OAuthConsumer(null, credentials.getUserPrincipal().getName(), credentials.getPassword(), null));
    }
}

