/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.common.query;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.params.AppendedSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.dataone.service.types.v1.Subject;

public abstract class SolrQueryService {
    public static final String WT = "wt";
    protected static final String FILTERQUERY = "fq";
    protected static final String UNKNOWN = "Unknown";
    private static final String READPERMISSION = "readPermission";
    private static final String CHANGEPERMISSION = "changePermission";
    private static final String WRITEPERMISSION = "writePermission";
    private static final String IS_PUBLIC = "isPublic";
    private static final String RIGHTSHOLDER = "rightsHolder";
    private static final String OPENPARENTHESES = "(";
    private static final String CLOSEPARENTHESES = ")";
    private static final String COLON = ":";
    private static final String OR = "OR";
    private static Log log = LogFactory.getLog(SolrQueryService.class);
    private static List<String> supportedWriterTypes = null;
    protected IndexSchema schema = null;
    protected Map<String, SchemaField> fieldMap = null;
    protected List<String> validSolrFieldNames = null;
    protected String solrSpecVersion = null;

    public abstract InputStream query(SolrParams var1, Set<Subject> var2, SolrRequest.METHOD var3) throws Exception;

    public abstract Map<String, SchemaField> getIndexSchemaFields() throws Exception;

    public IndexSchema getSchema() {
        return this.schema;
    }

    public abstract String getSolrServerVersion();

    protected List<String> getValidSchemaFields() {
        if (this.validSolrFieldNames != null && !this.validSolrFieldNames.isEmpty()) {
            return this.validSolrFieldNames;
        }
        this.validSolrFieldNames = new ArrayList<String>();
        if (this.fieldMap != null) {
            Set<String> fieldNames = this.fieldMap.keySet();
            for (String fieldName : fieldNames) {
                SchemaField field = this.fieldMap.get(fieldName);
                if (field == null || this.schema.isCopyFieldTarget(field)) continue;
                this.validSolrFieldNames.add(fieldName);
            }
        }
        return this.validSolrFieldNames;
    }

    public static boolean isSupportedWT(String wt) {
        return wt == null || supportedWriterTypes.contains(wt);
    }

    protected SolrParams appendAccessFilterParams(SolrParams solrParams, Set<Subject> subjects) {
        SolrParams append = null;
        if (solrParams != null) {
            StringBuffer query = this.generateAccessFilterParamsString(subjects);
            if (query != null && query.length() != 0) {
                log.info((Object)("=================== fq query is " + query.toString()));
                NamedList fq = new NamedList();
                fq.add(FILTERQUERY, (Object)query.toString());
                SolrParams fqParam = SolrParams.toSolrParams((NamedList)fq);
                append = AppendedSolrParams.wrapAppended((SolrParams)solrParams, (SolrParams)fqParam);
            } else {
                append = solrParams;
            }
        }
        return append;
    }

    protected StringBuffer generateAccessFilterParamsString(Set<Subject> subjects) {
        StringBuffer query = new StringBuffer();
        boolean first = true;
        if (subjects != null) {
            for (Subject subject : subjects) {
                String subjectName;
                if (subject == null || (subjectName = subject.getValue()) == null || subjectName.trim().equals("")) continue;
                if (first) {
                    first = false;
                    query.append("(readPermission:\"" + subjectName + "\"" + CLOSEPARENTHESES);
                    query.append("OR(writePermission:\"" + subjectName + "\"" + CLOSEPARENTHESES);
                    query.append("OR(changePermission:\"" + subjectName + "\"" + CLOSEPARENTHESES);
                    if (!subjectName.equals("public") && !subjectName.equals("authenticatedUser")) {
                        query.append("OR(rightsHolder:\"" + subjectName + "\"" + CLOSEPARENTHESES);
                        continue;
                    }
                    if (!subjectName.equals("public")) continue;
                    query.append("OR(isPublic:true)");
                    continue;
                }
                query.append("OR(readPermission:\"" + subjectName + "\"" + CLOSEPARENTHESES);
                query.append("OR(writePermission:\"" + subjectName + "\"" + CLOSEPARENTHESES);
                query.append("OR(changePermission:\"" + subjectName + "\"" + CLOSEPARENTHESES);
                if (!subjectName.equals("public") && !subjectName.equals("authenticatedUser")) {
                    query.append("OR(rightsHolder:\"" + subjectName + "\"" + CLOSEPARENTHESES);
                    continue;
                }
                if (!subjectName.equals("public")) continue;
                query.append("OR(isPublic:true)");
            }
        }
        return query;
    }

    static {
        supportedWriterTypes = new ArrayList<String>();
        supportedWriterTypes.add("csv");
        supportedWriterTypes.add("json");
        supportedWriterTypes.add("php");
        supportedWriterTypes.add("phps");
        supportedWriterTypes.add("ruby");
        supportedWriterTypes.add("velocity");
        supportedWriterTypes.add("python");
        supportedWriterTypes.add("xml");
    }
}

