/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.dao;

import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;

public class MetacatDataSourceFactory {
    private static final Log log = LogFactory.getLog(MetacatDataSourceFactory.class);
    private static BasicDataSource metacatDataSource;
    private static final String metacatUrlProperty = "metacat.datasource.url";
    private static final String metacatDriverClassProperty = "metacat.datasource.driverClass";
    private static final String metacatUsernameProperty = "database.user";
    private static final String metacatPasswordProperty = "database.password";
    private static final String metacatInitialPoolSizeProperty = "metacat.datasource.initialSize";
    private static final String metacatMaxPoolSizeProperty = "metacat.datasource.maxSize";
    private static final String metacatUrl;
    private static final String metacatDriverClass;
    private static final String metacatUsername;
    private static final String metacatPassword;
    private static final String metacatInitialPoolSize;
    private static final String metacatMaxPoolSize;

    private MetacatDataSourceFactory() {
    }

    public static BasicDataSource getMetacatDataSource() {
        if (metacatDataSource == null) {
            MetacatDataSourceFactory.initMetacatDataSource();
        }
        return metacatDataSource;
    }

    private static void initMetacatDataSource() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Metacat Data Source JDBC settings:");
            log.debug((Object)("\tmetacat.datasource.url:" + metacatUrl));
            log.debug((Object)("\tmetacat.datasource.driverClass:" + metacatDriverClass));
            log.debug((Object)("\tdatabase.user:" + metacatUsername));
            log.debug((Object)("\tdatabase.password:" + metacatPassword));
            log.debug((Object)("\tmetacat.datasource.initialSize:" + metacatInitialPoolSize));
            log.debug((Object)("\tmetacat.datasource.maxSize:" + metacatMaxPoolSize));
        }
        metacatDataSource = new BasicDataSource();
        metacatDataSource.setUrl(metacatUrl);
        metacatDataSource.setDriverClassName(metacatDriverClass);
        metacatDataSource.setUsername(metacatUsername);
        metacatDataSource.setPassword(metacatPassword);
        metacatDataSource.setInitialSize(Integer.valueOf(metacatInitialPoolSize).intValue());
        metacatDataSource.setMaxActive(Integer.valueOf(metacatMaxPoolSize).intValue());
    }

    static {
        metacatUrl = Settings.getConfiguration().getString(metacatUrlProperty);
        metacatDriverClass = Settings.getConfiguration().getString(metacatDriverClassProperty);
        metacatUsername = Settings.getConfiguration().getString(metacatUsernameProperty);
        metacatPassword = Settings.getConfiguration().getString(metacatPasswordProperty);
        metacatInitialPoolSize = Settings.getConfiguration().getString(metacatInitialPoolSizeProperty);
        metacatMaxPoolSize = Settings.getConfiguration().getString(metacatMaxPoolSizeProperty);
    }
}

