/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.servlet.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.xml.parsers.ParserConfigurationException;
import org.dataone.cn.servlet.http.BufferedServletOutputStream;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.util.ExceptionHandler;
import org.xml.sax.SAXException;

public class BufferedServletResponseWrapper
extends HttpServletResponseWrapper
implements HttpServletResponse,
ServletResponse {
    private BufferedServletOutputStream bufferedServletOut = new BufferedServletOutputStream();
    private PrintWriter printWriter = null;
    private ServletOutputStream outputStream = null;
    private int status = -1;
    private BaseException d1Exception = null;
    private String contentType;

    public BufferedServletResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public byte[] getBuffer() {
        return this.bufferedServletOut.getBuffer();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStream != null) {
            throw new IllegalStateException("The Servlet API forbids calling getWriter( ) after getOutputStream( ) has been called");
        }
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter((OutputStream)((Object)this.bufferedServletOut));
        }
        return this.printWriter;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter != null) {
            throw new IllegalStateException("The Servlet API forbids calling getOutputStream( ) after getWriter( ) has been called");
        }
        if (this.outputStream == null) {
            this.outputStream = this.bufferedServletOut;
        }
        return this.outputStream;
    }

    public void flushBuffer() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        } else if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    public int getBufferSize() {
        return this.bufferedServletOut.getBuffer().length;
    }

    public void reset() {
        this.bufferedServletOut.reset();
    }

    public void resetBuffer() {
        this.bufferedServletOut.reset();
    }

    public void setBufferSize(int size) {
        this.bufferedServletOut.setBufferSize(size);
    }

    public void setStatus(int sc) {
        this.status = sc;
        super.setStatus(sc);
    }

    public int getStatus() {
        return this.status;
    }

    public Boolean isException() {
        String errorCheck = new String(Arrays.copyOfRange(this.getBuffer(), 0, 100));
        ServiceFailure d1Exception = null;
        Boolean isException = null;
        if (errorCheck.contains("<error")) {
            isException = true;
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(this.getBuffer());
                String statusInt = String.valueOf(this.getStatus());
                d1Exception = ExceptionHandler.deserializeXml((InputStream)inputStream, (String)(statusInt + ": "));
                this.setD1Exception((BaseException)d1Exception);
            }
            catch (IllegalStateException ex) {
                d1Exception = new ServiceFailure("0", "BaseExceptionHandler.deserializeXml: " + ex.getMessage());
            }
            catch (ParserConfigurationException ex) {
                d1Exception = new ServiceFailure("0", "BaseExceptionHandler.deserializeXml: " + ex.getMessage());
            }
            catch (SAXException ex) {
                d1Exception = new ServiceFailure("0", "BaseExceptionHandler.deserializeXml: " + ex.getMessage());
            }
            catch (IOException ex) {
                d1Exception = new ServiceFailure("0", "BaseExceptionHandler.deserializeXml: " + ex.getMessage());
            }
            this.setD1Exception((BaseException)d1Exception);
        } else {
            isException = false;
        }
        return isException;
    }

    public BaseException getD1Exception() {
        return this.d1Exception;
    }

    public void setD1Exception(BaseException d1Exception) {
        this.d1Exception = d1Exception;
    }

    public void setContentType(String type) {
        this.contentType = type;
        super.setContentType(type);
    }

    public String getContentType() {
        return this.contentType;
    }
}

