/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.EncoderException;
import org.apache.log4j.Logger;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.XmlDocumentUtility;
import org.dataone.cn.indexer.annotation.OntologyModelService;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.ISolrField;
import org.dataone.cn.indexer.parser.SubprocessorUtility;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;

public class EmlAnnotationSubprocessor
implements IDocumentSubprocessor {
    private static Logger log = Logger.getLogger((String)EmlAnnotationSubprocessor.class.getName());
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();
    @Autowired
    private SubprocessorUtility processorUtility;
    private List<String> matchDocuments = null;
    private List<String> fieldsToMerge = new ArrayList<String>();
    private List<ISolrField> fieldList = new ArrayList<ISolrField>();
    private static XPathFactory xpathFactory = null;
    private static XPath xpath = null;

    @Override
    public boolean canProcess(String formatId) {
        return this.matchDocuments.contains(formatId);
    }

    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, InputStream is) throws Exception {
        log.debug((Object)(this.getClass().getName() + ".processDocument() called for identifier " + identifier));
        Document doc = XmlDocumentUtility.generateXmlDocument(is);
        SolrDoc solrDoc = docs.get(identifier);
        if (solrDoc == null) {
            solrDoc = new SolrDoc();
            docs.put(identifier, solrDoc);
        }
        HashMap expandedFields = new HashMap();
        for (ISolrField solrField : this.fieldList) {
            long getFieldsStart = System.currentTimeMillis();
            try {
                List<SolrElementField> fields = solrField.getFields(doc, identifier);
                for (SolrElementField field : fields) {
                    log.debug((Object)("Expanding concepts for " + field.getName() + ": " + field.getValue()));
                    Map<String, Set<String>> expandedConcepts = OntologyModelService.getInstance().expandConcepts(field.getValue());
                    for (Map.Entry<String, Set<String>> expandedField : expandedConcepts.entrySet()) {
                        for (String value : expandedField.getValue()) {
                            if (!expandedFields.containsKey(field.getName())) {
                                expandedFields.put(field.getName(), new HashSet());
                            }
                            ((Set)expandedFields.get(field.getName())).add(value);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String fieldName = solrField.getName();
            this.perfLog.log("BaseXPathDocumentSubprocessor.processDocument() processing id " + identifier + " of field " + solrField.getClass().getSimpleName() + "(\"" + fieldName + "\").getFields()", System.currentTimeMillis() - getFieldsStart);
        }
        log.debug((Object)("About to add expandedFields of size " + expandedFields.size()));
        for (String field : expandedFields.keySet()) {
            log.debug((Object)("Adding field " + field + " to solrDoc"));
            for (String concept : (Set)expandedFields.get(field)) {
                log.debug((Object)("  concept is " + concept));
                solrDoc.addField(new SolrElementField(field, concept));
            }
        }
        return docs;
    }

    @Override
    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        return this.processorUtility.mergeWithIndexedDocument(indexDocument, this.fieldsToMerge);
    }

    public SubprocessorUtility getProcessorUtility() {
        return this.processorUtility;
    }

    public void setProcessorUtility(SubprocessorUtility processorUtility) {
        this.processorUtility = processorUtility;
    }

    public PerformanceLogger getPerfLog() {
        return this.perfLog;
    }

    public void setPerfLog(PerformanceLogger perfLog) {
        this.perfLog = perfLog;
    }

    public List<String> getMatchDocuments() {
        return this.matchDocuments;
    }

    public void setMatchDocuments(List<String> matchDocuments) {
        this.matchDocuments = matchDocuments;
    }

    public List<String> getFieldsToMerge() {
        return this.fieldsToMerge;
    }

    public void setFieldsToMerge(List<String> fieldsToMerge) {
        this.fieldsToMerge = fieldsToMerge;
    }

    public List<ISolrField> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<ISolrField> fieldList) {
        this.fieldList = fieldList;
        this.initExpression(xpath);
    }

    public void initExpression(XPath xpathObject) {
        for (ISolrField solrField : this.fieldList) {
            solrField.initExpression(xpathObject);
        }
    }

    static {
        xpathFactory = XPathFactory.newInstance();
        xpath = xpathFactory.newXPath();
    }
}

