/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.commons.codec.EncoderException;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.XMLNamespaceConfig;
import org.dataone.cn.indexer.XmlDocumentUtility;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.ISolrField;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.w3c.dom.Document;

public class BaseXPathDocumentSubprocessor
implements IDocumentSubprocessor {
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();
    private static XPathFactory xpathFactory = null;
    private static XPath xpath = null;
    private List<String> matchDocuments = null;
    private List<ISolrField> fieldList = new ArrayList<ISolrField>();

    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, InputStream is) throws Exception {
        SolrDoc metaDocument = docs.get(identifier);
        if (metaDocument == null) {
            metaDocument = new SolrDoc();
            docs.put(identifier, metaDocument);
        }
        long fetchXmlStart = System.currentTimeMillis();
        Document doc = XmlDocumentUtility.generateXmlDocument(is);
        this.perfLog.log("BaseXPathDocumentSubprocessor.processDocument() XmlDocumentUtility.generateXmlDocument() for id " + identifier, System.currentTimeMillis() - fetchXmlStart);
        long addAllFieldsStart = System.currentTimeMillis();
        for (ISolrField solrField : this.fieldList) {
            long getFieldsStart = System.currentTimeMillis();
            try {
                metaDocument.getFieldList().addAll(solrField.getFields(doc, identifier));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String fieldName = solrField.getName();
            this.perfLog.log("BaseXPathDocumentSubprocessor.processDocument() processing id " + identifier + " of field " + solrField.getClass().getSimpleName() + "(\"" + fieldName + "\").getFields()", System.currentTimeMillis() - getFieldsStart);
        }
        this.perfLog.log("BaseXPathDocumentSubprocessor.processDocument() processing ALL fields for id " + identifier, System.currentTimeMillis() - addAllFieldsStart);
        return docs;
    }

    @Override
    public boolean canProcess(String formatId) {
        return this.matchDocuments.contains(formatId);
    }

    public void initExpression(XPath xpathObject) {
        for (ISolrField solrField : this.fieldList) {
            solrField.initExpression(xpathObject);
        }
    }

    public List<ISolrField> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<ISolrField> fieldList) {
        this.fieldList = fieldList;
        this.initExpression(xpath);
    }

    public List<String> getMatchDocuments() {
        return this.matchDocuments;
    }

    public void setMatchDocuments(List<String> matchDocuments) {
        this.matchDocuments = matchDocuments;
    }

    public static void setXmlNamespaceConfig(XMLNamespaceConfig xmlNamespaceConfig) {
        xpath.setNamespaceContext(xmlNamespaceConfig);
    }

    @Override
    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        return indexDocument;
    }

    static {
        System.setProperty("javax.xml.xpath.XPathFactory:http://saxon.sf.net/jaxp/xpath/om", "net.sf.saxon.xpath.XPathFactoryImpl");
        try {
            xpathFactory = XPathFactory.newInstance("http://saxon.sf.net/jaxp/xpath/om");
        }
        catch (XPathFactoryConfigurationException e) {
            e.printStackTrace();
        }
        xpath = xpathFactory.newXPath();
    }
}

