/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagHelper;
import gov.loc.repository.bagit.PreBag;
import gov.loc.repository.bagit.impl.PreBagImpl;
import gov.loc.repository.bagit.v0_93.impl.BagPartFactoryImpl;
import gov.loc.repository.bagit.v0_94.impl.BagConstantsImpl;
import gov.loc.repository.bagit.v0_97.impl.BagImpl;
import java.io.File;
import java.util.List;

public class BagFactory {
    public static final Version LATEST = Version.V0_97;

    public Bag createBag() {
        return this.createBag(LATEST);
    }

    public Bag createBag(Version version) {
        if (Version.V0_93.equals((Object)version)) {
            return new gov.loc.repository.bagit.v0_93.impl.BagImpl(this);
        }
        if (Version.V0_94.equals((Object)version)) {
            return new gov.loc.repository.bagit.v0_94.impl.BagImpl(this);
        }
        if (Version.V0_95.equals((Object)version)) {
            return new gov.loc.repository.bagit.v0_95.impl.BagImpl(this);
        }
        if (Version.V0_96.equals((Object)version)) {
            return new gov.loc.repository.bagit.v0_96.impl.BagImpl(this);
        }
        if (Version.V0_97.equals((Object)version)) {
            return new BagImpl(this);
        }
        throw new RuntimeException("Not yet supported");
    }

    public Bag createBag(File bagFile) {
        return this.createBag(bagFile, LoadOption.BY_MANIFESTS);
    }

    public Bag createBag(File bagFile, LoadOption loadOption) {
        String versionString = BagHelper.getVersion(bagFile);
        Version version = LATEST;
        if (versionString != null) {
            for (Version v : Version.values()) {
                if (!v.versionString.equals(versionString)) continue;
                version = v;
            }
        }
        return this.createBag(bagFile, version, loadOption);
    }

    public Bag createBagByPayloadFiles(File bagFile, Version version, List<String> ignoreAdditionalDirectories) {
        Bag bag = this.createBag(version);
        bag.setFile(bagFile);
        bag.loadFromFiles(ignoreAdditionalDirectories);
        return bag;
    }

    public Bag createBag(File bagFile, Version version, LoadOption loadOption) {
        Bag bag = this.createBag(version);
        bag.setFile(bagFile);
        if (loadOption == null || LoadOption.BY_MANIFESTS.equals((Object)loadOption)) {
            bag.loadFromManifests();
        } else if (LoadOption.BY_FILES.equals((Object)loadOption)) {
            bag.loadFromFiles();
        }
        return bag;
    }

    public Bag createBag(Bag bag) {
        if (bag.getFile() == null) {
            return this.createBag(bag.getBagConstants().getVersion());
        }
        return this.createBag(bag.getFile(), bag.getBagConstants().getVersion(), LoadOption.NO_LOAD);
    }

    public Bag.BagPartFactory getBagPartFactory() {
        return this.getBagPartFactory(LATEST);
    }

    public Bag.BagPartFactory getBagPartFactory(Version version) {
        if (Version.V0_93.equals((Object)version)) {
            return new BagPartFactoryImpl(this, this.getBagConstants(version));
        }
        if (Version.V0_94.equals((Object)version)) {
            return new gov.loc.repository.bagit.v0_94.impl.BagPartFactoryImpl(this, this.getBagConstants(version));
        }
        if (Version.V0_95.equals((Object)version)) {
            return new gov.loc.repository.bagit.v0_95.impl.BagPartFactoryImpl(this, this.getBagConstants(version));
        }
        if (Version.V0_96.equals((Object)version)) {
            return new gov.loc.repository.bagit.v0_96.impl.BagPartFactoryImpl(this, this.getBagConstants(version));
        }
        if (Version.V0_97.equals((Object)version)) {
            return new gov.loc.repository.bagit.v0_97.impl.BagPartFactoryImpl(this, this.getBagConstants(version));
        }
        throw new RuntimeException("Not yet supported");
    }

    public Bag.BagConstants getBagConstants() {
        return this.getBagConstants(LATEST);
    }

    public Bag.BagConstants getBagConstants(Version version) {
        if (Version.V0_93.equals((Object)version)) {
            return new gov.loc.repository.bagit.v0_93.impl.BagConstantsImpl();
        }
        if (Version.V0_94.equals((Object)version)) {
            return new BagConstantsImpl();
        }
        if (Version.V0_95.equals((Object)version)) {
            return new gov.loc.repository.bagit.v0_95.impl.BagConstantsImpl();
        }
        if (Version.V0_96.equals((Object)version)) {
            return new gov.loc.repository.bagit.v0_96.impl.BagConstantsImpl();
        }
        if (Version.V0_97.equals((Object)version)) {
            return new gov.loc.repository.bagit.v0_97.impl.BagConstantsImpl();
        }
        throw new RuntimeException("Not yet supported");
    }

    public PreBag createPreBag(File dir) {
        PreBagImpl preBag = new PreBagImpl(this);
        preBag.setFile(dir);
        return preBag;
    }

    public static enum Version {
        V0_93("0.93"),
        V0_94("0.94"),
        V0_95("0.95"),
        V0_96("0.96"),
        V0_97("0.97");

        public String versionString;

        private Version(String versionString) {
            this.versionString = versionString;
        }

        public static Version valueOfString(String versionString) {
            for (Version version : Version.values()) {
                if (!version.versionString.equals(versionString)) continue;
                return version;
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum LoadOption {
        NO_LOAD,
        BY_MANIFESTS,
        BY_FILES;

    }
}

