/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSAlgorithmProvider;
import java.security.Provider;
import java.util.Collections;
import java.util.Set;

abstract class BaseJWSProvider
implements JWSAlgorithmProvider {
    private final Set<JWSAlgorithm> algs;
    protected Provider provider = null;

    public BaseJWSProvider(Set<JWSAlgorithm> algs) {
        if (algs == null) {
            throw new IllegalArgumentException("The supported JWS algorithm set must not be null");
        }
        this.algs = Collections.unmodifiableSet(algs);
    }

    @Override
    public Set<JWSAlgorithm> supportedAlgorithms() {
        return this.algs;
    }

    @Override
    public void setProvider(Provider provider) {
        this.provider = provider;
    }
}

