/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import org.ecoinformatics.datamanager.database.SelectionItem;
import org.ecoinformatics.datamanager.database.UnWellFormedQueryException;

public class GroupBy {
    private static final String GROUP_BY = "GROUP BY";
    private SelectionItem[] groupByList = null;

    public void addGroupByItem(SelectionItem groupItem) {
        if (this.groupByList == null) {
            this.groupByList = new SelectionItem[1];
            this.groupByList[0] = groupItem;
        } else {
            int size = this.groupByList.length;
            SelectionItem[] copy = this.groupByList;
            this.groupByList = new SelectionItem[size + 1];
            for (int i = 0; i < size; ++i) {
                this.groupByList[i] = copy[i];
            }
            this.groupByList[size] = groupItem;
        }
    }

    public String toSQLString() throws UnWellFormedQueryException {
        StringBuffer sql = new StringBuffer();
        if (this.groupByList != null && this.groupByList.length > 0) {
            sql.append(GROUP_BY);
            sql.append(" ");
            int selectionLength = this.groupByList.length;
            boolean firstSelection = true;
            for (int i = 0; i < selectionLength; ++i) {
                SelectionItem selection = this.groupByList[i];
                if (firstSelection) {
                    sql.append(selection.toSQLString());
                    firstSelection = false;
                    continue;
                }
                sql.append(",");
                sql.append(selection.toSQLString());
            }
        }
        return sql.toString();
    }
}

