/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.parser;

import java.util.Vector;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.Entity;

public class AttributeList {
    private Vector<Attribute> attributes = new Vector();
    private String id = null;
    private boolean isReference = false;
    private String referenceId = null;
    private Entity parentTable = null;

    public Attribute[] getAttributes() {
        if (this.attributes == null || this.attributes.size() == 0) {
            return null;
        }
        int size = this.attributes.size();
        Attribute[] list = new Attribute[size];
        for (int i = 0; i < size; ++i) {
            list[i] = this.attributes.elementAt(i);
        }
        return list;
    }

    public String[] getDBFieldNames() {
        if (this.attributes == null || this.attributes.size() == 0) {
            return null;
        }
        int size = this.attributes.size();
        String[] list = new String[size];
        for (int i = 0; i < size; ++i) {
            Attribute attribute = this.attributes.elementAt(i);
            list[i] = attribute.getDBFieldName();
        }
        return list;
    }

    public String getId() {
        return this.id;
    }

    public String[] getNames() {
        if (this.attributes == null || this.attributes.size() == 0) {
            return null;
        }
        int size = this.attributes.size();
        String[] list = new String[size];
        for (int i = 0; i < size; ++i) {
            Attribute attribute = this.attributes.elementAt(i);
            list[i] = attribute.getName();
        }
        return list;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public void setReference(boolean isReference) {
        this.isReference = isReference;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setParent(Entity entity) {
        this.parentTable = entity;
    }

    public Entity getParent() {
        return this.parentTable;
    }

    public void add(Attribute a) {
        this.attributes.addElement(a);
    }

    public Attribute[] getAttributes(String name) {
        if (this.attributes == null || this.attributes.size() == 0) {
            return null;
        }
        Vector<Attribute> list = new Vector<Attribute>();
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute a = this.attributes.elementAt(i);
            if (!a.getName().equals(name)) continue;
            list.add(a);
        }
        return list.toArray(new Attribute[0]);
    }

    public Attribute getAttribute(String name) {
        Attribute[] list = this.getAttributes(name);
        if (list != null && list.length > 0) {
            return list[0];
        }
        return null;
    }
}

