/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogUtils {
    public static String getCaller(Class<?> clazz) {
        return LogUtils.getCaller(clazz, 1);
    }

    public static String getCaller(Class<?> me, int nframes) {
        String result;
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        int stackTracePosition = LogUtils.getCallerPosition(me, stes);
        if (stackTracePosition >= stes.length - 1) {
            result = "class [" + me.getName() + "] not found in caller's stack trace.";
        } else {
            StringBuffer resBuffer = new StringBuffer();
            for (int i = stackTracePosition; i < stes.length && i < stackTracePosition + nframes; ++i) {
                StackTraceElement stelement = stes[i];
                String className = stelement.getClassName();
                String simpleClassName = className.substring(className.lastIndexOf(46) + 1);
                if (resBuffer.length() > 0) {
                    resBuffer.append(" / ");
                }
                resBuffer.append(simpleClassName + "." + stelement.getMethodName() + ":" + stelement.getLineNumber());
            }
            result = resBuffer.toString();
        }
        return result;
    }

    private static int getCallerPosition(Class<?> me, StackTraceElement[] stes) {
        int stackTracePosition;
        StackTraceElement stackTraceElement;
        boolean foundCaller = false;
        boolean foundClazz = false;
        for (stackTracePosition = 0; stackTracePosition < stes.length && !foundCaller; foundCaller |= (foundClazz |= me.getName().equals(stackTraceElement.getClassName())) && !me.getName().equals(stackTraceElement.getClassName()), ++stackTracePosition) {
            stackTraceElement = stes[stackTracePosition];
        }
        return --stackTracePosition;
    }

    private LogUtils() {
    }
}

