/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.io.InputStream;
import java.util.Vector;
import org.ecoinformatics.datamanager.database.DelimitedReader;
import org.ecoinformatics.datamanager.database.TextDataReader;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.parser.TextComplexDataFormat;
import org.ecoinformatics.datamanager.parser.TextDelimitedDataFormat;
import org.ecoinformatics.datamanager.parser.TextWidthFixedDataFormat;

public class TextComplexFormatDataReader
extends TextDataReader {
    public static final String DEFAULTVALUE = "";
    private InputStream dataStream = null;
    private Entity entity = null;
    private boolean stripHeader = true;
    private int numberOfAttirbute = 0;
    private TextComplexDataFormat[] formats = null;
    private String physicalLineDelimiter = null;
    private int numberOfHeaderLines = 0;
    private int physicalLineDelimiterLength = 0;
    private int headLineNumberCount = 0;

    public TextComplexFormatDataReader(InputStream dataStream, Entity entity) throws Exception {
        this(dataStream, entity, true);
    }

    public TextComplexFormatDataReader(InputStream dataStream, Entity entity, boolean stripHeader) throws Exception {
        if (dataStream == null || entity == null) {
            throw new Exception("Data inputstream or entity metadata is null");
        }
        this.dataStream = dataStream;
        this.entity = entity;
        this.stripHeader = stripHeader;
        this.getParameterFromEntity();
    }

    private void getParameterFromEntity() throws Exception {
        Attribute[] attributeList = this.entity.getAttributes();
        if (attributeList == null) {
            throw new Exception("Attribute in entity metadata is null");
        }
        this.numberOfAttirbute = attributeList.length;
        this.numberOfHeaderLines = this.entity.getNumHeaderLines();
        if (this.numberOfHeaderLines == -1) {
            this.numberOfHeaderLines = 0;
        }
        this.physicalLineDelimiter = this.entity.getPhysicalLineDelimiter();
        if (this.physicalLineDelimiter == null) {
            this.physicalLineDelimiter = this.entity.getRecordDelimiter();
        }
        this.physicalLineDelimiter = DelimitedReader.unescapeDelimiter(this.physicalLineDelimiter);
        this.physicalLineDelimiterLength = this.physicalLineDelimiter.length();
        this.formats = this.entity.getDataFormatArray();
        if (this.formats == null) {
            throw new Exception("Complext format is null in metadata entity");
        }
        int length = this.formats.length;
        if (length != this.numberOfAttirbute) {
            throw new Exception("Complex formats should have same number as attribute number");
        }
    }

    public Vector getOneRowDataVector() throws Exception {
        Vector<String> oneRowDataVector = new Vector<String>();
        StringBuffer lineDelimiterBuffer = new StringBuffer();
        StringBuffer fieldValueBuffer = new StringBuffer();
        int singleCharactor = -2;
        int columnCount = 1;
        int attributeCount = 0;
        boolean startNewAttribute = true;
        boolean isWidthFix = true;
        int width = -1;
        int widthCount = 0;
        boolean startWidthCount = false;
        int startColumnNumberFromFormat = -1;
        String fieldDelimiter = null;
        if (this.dataStream != null) {
            singleCharactor = this.dataStream.read();
            while (singleCharactor != -1) {
                char charactor = (char)singleCharactor;
                if (this.stripHeader && this.numberOfHeaderLines > 0 && this.headLineNumberCount < this.numberOfHeaderLines) {
                    lineDelimiterBuffer.append(charactor);
                    if (lineDelimiterBuffer.length() == this.physicalLineDelimiterLength && lineDelimiterBuffer.toString().equals(this.physicalLineDelimiter)) {
                        lineDelimiterBuffer = new StringBuffer();
                        ++this.headLineNumberCount;
                    } else if (lineDelimiterBuffer.length() == this.physicalLineDelimiterLength) {
                        lineDelimiterBuffer = new StringBuffer();
                    }
                } else {
                    String value;
                    fieldValueBuffer.append(charactor);
                    lineDelimiterBuffer.append(charactor);
                    if (startNewAttribute) {
                        startNewAttribute = false;
                        TextComplexDataFormat format = this.formats[attributeCount];
                        if (format == null) {
                            throw new Exception("The text format is null for an attribute");
                        }
                        if (format instanceof TextWidthFixedDataFormat) {
                            TextWidthFixedDataFormat widthFormat = (TextWidthFixedDataFormat)format;
                            width = widthFormat.getFieldWidth();
                            startColumnNumberFromFormat = widthFormat.getFieldStartColumn();
                            isWidthFix = true;
                            startWidthCount = false;
                        } else if (format instanceof TextDelimitedDataFormat) {
                            TextDelimitedDataFormat delimitedFormat = (TextDelimitedDataFormat)format;
                            fieldDelimiter = delimitedFormat.getFieldDelimiter();
                            isWidthFix = false;
                        }
                    }
                    if (isWidthFix) {
                        if (startColumnNumberFromFormat != -1 && startColumnNumberFromFormat == columnCount) {
                            fieldValueBuffer = new StringBuffer();
                            fieldValueBuffer.append(charactor);
                            startWidthCount = true;
                        } else if (startColumnNumberFromFormat == -1) {
                            startWidthCount = true;
                        }
                        if (startWidthCount) {
                            ++widthCount;
                        }
                        if (widthCount == width) {
                            value = fieldValueBuffer.toString();
                            oneRowDataVector.add(value.trim());
                            widthCount = 0;
                            startWidthCount = false;
                            fieldValueBuffer = new StringBuffer();
                            startNewAttribute = true;
                            ++attributeCount;
                        }
                    } else if (fieldValueBuffer.toString().endsWith(fieldDelimiter)) {
                        value = fieldValueBuffer.toString();
                        value = value.substring(0, value.length() - fieldDelimiter.length());
                        oneRowDataVector.add(value.trim());
                        fieldValueBuffer = new StringBuffer();
                        startNewAttribute = true;
                        ++attributeCount;
                    }
                    ++columnCount;
                    if (lineDelimiterBuffer.length() == this.physicalLineDelimiterLength && lineDelimiterBuffer.toString().equals(this.physicalLineDelimiter)) {
                        lineDelimiterBuffer = new StringBuffer();
                        columnCount = 1;
                    } else if (lineDelimiterBuffer.length() == this.physicalLineDelimiterLength) {
                        lineDelimiterBuffer = new StringBuffer();
                    }
                    if (attributeCount == this.numberOfAttirbute) break;
                }
                singleCharactor = this.dataStream.read();
            }
        }
        if (!oneRowDataVector.isEmpty() && oneRowDataVector.size() < this.numberOfAttirbute) {
            int size;
            for (int i = size = oneRowDataVector.size(); i < this.numberOfAttirbute; ++i) {
                oneRowDataVector.add(DEFAULTVALUE);
            }
        }
        return oneRowDataVector;
    }

    public InputStream getDataStream() {
        return this.dataStream;
    }

    public void setDataStream(InputStream dataStream) {
        this.dataStream = dataStream;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }
}

