/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import org.apache.commons.exec.TimeoutObserver;
import org.apache.commons.exec.Watchdog;

public class ExecuteWatchdog
implements TimeoutObserver {
    private Process process;
    private boolean watch = false;
    private Exception caught;
    private boolean killedProcess = false;
    private final Watchdog watchdog;

    public ExecuteWatchdog(long timeout) {
        this.watchdog = new Watchdog(timeout);
        this.watchdog.addTimeoutObserver(this);
    }

    public synchronized void start(Process process) {
        if (process == null) {
            throw new NullPointerException("process is null.");
        }
        if (this.process != null) {
            throw new IllegalStateException("Already running.");
        }
        this.caught = null;
        this.killedProcess = false;
        this.watch = true;
        this.process = process;
        this.watchdog.start();
    }

    public synchronized void stop() {
        this.watchdog.stop();
        this.watch = false;
        this.process = null;
    }

    public synchronized void destroyProcess() {
        this.timeoutOccured(new Watchdog(1L));
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void timeoutOccured(Watchdog w) {
        try {
            try {
                if (this.process != null) {
                    this.process.exitValue();
                }
            }
            catch (IllegalThreadStateException itse) {
                if (this.watch) {
                    this.killedProcess = true;
                    this.process.destroy();
                }
            }
        }
        catch (Exception e) {
            this.caught = e;
        }
        finally {
            this.cleanUp();
        }
    }

    public synchronized void checkException() throws Exception {
        if (this.caught != null) {
            throw this.caught;
        }
    }

    public synchronized boolean isWatching() {
        return this.watch;
    }

    public synchronized boolean killedProcess() {
        return this.killedProcess;
    }

    protected synchronized void cleanUp() {
        this.watch = false;
        this.process = null;
    }
}

