/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvictLocalMapEntriesCallable
implements Callable<Boolean>,
HazelcastInstanceAware,
DataSerializable {
    private static final long serialVersionUID = -8809741591882405286L;
    private transient HazelcastInstance hazelcastInstance;
    private String mapName;
    private int percentage;

    public EvictLocalMapEntriesCallable() {
    }

    public EvictLocalMapEntriesCallable(String mapName, int percentage) {
        this.mapName = mapName;
        this.percentage = percentage;
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @Override
    public Boolean call() throws Exception {
        CMap cmap = this.getCMap(this.hazelcastInstance, this.mapName);
        cmap.evict(this.percentage);
        return true;
    }

    private ConcurrentMapManager getConcurrentMapManager(HazelcastInstance h) {
        FactoryImpl factory = (FactoryImpl)h;
        return factory.node.concurrentMapManager;
    }

    private CMap getCMap(HazelcastInstance h, String name) {
        ConcurrentMapManager concurrentMapManager = this.getConcurrentMapManager(h);
        String fullName = "c:" + name;
        return concurrentMapManager.getMap(fullName);
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        out.writeInt(this.percentage);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.mapName = in.readUTF();
        this.percentage = in.readInt();
    }
}

