/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.IGetAwareProxy;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MProxyImpl;
import com.hazelcast.impl.MultiMapProxy;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.Clock;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MultiMapProxyImpl
extends FactoryAwareNamedProxy
implements MultiMapProxy,
DataSerializable,
IGetAwareProxy {
    private transient MultiMapProxy base = null;

    public MultiMapProxyImpl() {
    }

    MultiMapProxyImpl(String name, FactoryImpl factory) {
        this.setName(name);
        this.setHazelcastInstance(factory);
        this.base = new MultiMapReal();
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.base == null) {
            this.base = (MultiMapProxy)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    public MultiMapReal getBase() {
        return (MultiMapReal)this.base;
    }

    public MProxy getMProxy() {
        this.ensure();
        return this.base.getMProxy();
    }

    public LocalMapStats getLocalMultiMapStats() {
        return this.base.getLocalMultiMapStats();
    }

    public String getLongName() {
        this.ensure();
        return this.base.getLongName();
    }

    public Object getId() {
        this.ensure();
        return this.base.getId();
    }

    public String toString() {
        return "MultiMap [" + this.getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiMapProxyImpl that = (MultiMapProxyImpl)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public Instance.InstanceType getInstanceType() {
        this.ensure();
        return this.base.getInstanceType();
    }

    public void destroy() {
        this.factory.destroyInstanceClusterWide(this.name, null);
    }

    public String getName() {
        return this.name.substring("m:u:".length());
    }

    public boolean put(Object key, Object value) {
        this.ensure();
        return this.base.put(key, value);
    }

    public Collection get(Object key) {
        this.ensure();
        return this.base.get(key);
    }

    public boolean remove(Object key, Object value) {
        this.ensure();
        return this.base.remove(key, value);
    }

    public Collection remove(Object key) {
        this.ensure();
        return this.base.remove(key);
    }

    public Set localKeySet() {
        this.ensure();
        return this.base.localKeySet();
    }

    public Set keySet() {
        this.ensure();
        return this.base.keySet();
    }

    public Collection values() {
        this.ensure();
        return this.base.values();
    }

    public Set entrySet() {
        this.ensure();
        return this.base.entrySet();
    }

    public boolean containsKey(Object key) {
        this.ensure();
        return this.base.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this.ensure();
        return this.base.containsValue(value);
    }

    public boolean containsEntry(Object key, Object value) {
        this.ensure();
        return this.base.containsEntry(key, value);
    }

    public int size() {
        this.ensure();
        return this.base.size();
    }

    public void clear() {
        this.ensure();
        this.base.clear();
    }

    public int valueCount(Object key) {
        this.ensure();
        return this.base.valueCount(key);
    }

    public void addLocalEntryListener(EntryListener entryListener) {
        this.ensure();
        this.base.addLocalEntryListener(entryListener);
    }

    public void addEntryListener(EntryListener entryListener, boolean includeValue) {
        this.ensure();
        this.base.addEntryListener(entryListener, includeValue);
    }

    public void removeEntryListener(EntryListener entryListener) {
        this.ensure();
        this.base.removeEntryListener(entryListener);
    }

    public void addEntryListener(EntryListener entryListener, Object key, boolean includeValue) {
        this.ensure();
        this.base.addEntryListener(entryListener, key, includeValue);
    }

    public void removeEntryListener(EntryListener entryListener, Object key) {
        this.ensure();
        this.base.removeEntryListener(entryListener, key);
    }

    public void lock(Object key) {
        this.ensure();
        this.base.lock(key);
    }

    public boolean tryLock(Object key) {
        this.ensure();
        return this.base.tryLock(key);
    }

    public boolean tryLock(Object key, long time, TimeUnit timeunit) {
        this.ensure();
        return this.base.tryLock(key, time, timeunit);
    }

    public void unlock(Object key) {
        this.ensure();
        this.base.unlock(key);
    }

    public boolean lockMap(long time, TimeUnit timeunit) {
        this.ensure();
        return this.base.lockMap(time, timeunit);
    }

    public void unlockMap() {
        this.ensure();
        this.base.unlockMap();
    }

    class MultiMapReal
    implements MultiMapProxy,
    IGetAwareProxy {
        final MProxy mapProxy;

        private MultiMapReal() {
            this.mapProxy = new MProxyImpl(MultiMapProxyImpl.this.name, MultiMapProxyImpl.this.factory);
        }

        public MProxy getMProxy() {
            return this.mapProxy;
        }

        public String getLongName() {
            return MultiMapProxyImpl.this.name;
        }

        public String getName() {
            return MultiMapProxyImpl.this.getName();
        }

        public void clear() {
            this.mapProxy.clear();
        }

        public boolean containsEntry(Object key, Object value) {
            return this.mapProxy.containsEntry(key, value);
        }

        public boolean containsKey(Object key) {
            return this.mapProxy.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.mapProxy.containsValue(value);
        }

        public Collection get(Object key) {
            long begin = Clock.currentTimeMillis();
            this.mapProxy.getMapOperationCounter().incrementGets(Clock.currentTimeMillis() - begin);
            ConcurrentMapManager.MMultiGet multiGet = ((MultiMapProxyImpl)MultiMapProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MMultiGet();
            return multiGet.get(MultiMapProxyImpl.this.name, key);
        }

        public boolean put(Object key, Object value) {
            return this.mapProxy.putMulti(key, value);
        }

        public boolean remove(Object key, Object value) {
            return this.mapProxy.removeMulti(key, value);
        }

        public Collection remove(Object key) {
            ConcurrentMapManager.MRemoveMulti m = ((MultiMapProxyImpl)MultiMapProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MRemoveMulti();
            long begin = Clock.currentTimeMillis();
            this.mapProxy.getMapOperationCounter().incrementRemoves(Clock.currentTimeMillis() - begin);
            return m.remove(MultiMapProxyImpl.this.name, key);
        }

        public int size() {
            return this.mapProxy.size();
        }

        public Set localKeySet() {
            return this.mapProxy.localKeySet();
        }

        public Set keySet() {
            return this.mapProxy.keySet();
        }

        public Collection values() {
            return this.mapProxy.values();
        }

        public Set entrySet() {
            return this.mapProxy.entrySet();
        }

        public int valueCount(Object key) {
            return this.mapProxy.valueCount(key);
        }

        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.MULTIMAP;
        }

        public void destroy() {
            this.mapProxy.destroy();
        }

        public Object getId() {
            return MultiMapProxyImpl.this.name;
        }

        public void addLocalEntryListener(EntryListener entryListener) {
            this.mapProxy.addLocalEntryListener(entryListener);
        }

        public void addEntryListener(EntryListener entryListener, boolean includeValue) {
            this.mapProxy.addEntryListener(entryListener, includeValue);
        }

        public void removeEntryListener(EntryListener entryListener) {
            this.mapProxy.removeEntryListener(entryListener);
        }

        public void addEntryListener(EntryListener entryListener, Object key, boolean includeValue) {
            this.mapProxy.addEntryListener(entryListener, key, includeValue);
        }

        public void removeEntryListener(EntryListener entryListener, Object key) {
            this.mapProxy.removeEntryListener(entryListener, key);
        }

        public void lock(Object key) {
            this.mapProxy.lock(key);
        }

        public boolean tryLock(Object key) {
            return this.mapProxy.tryLock(key);
        }

        public boolean tryLock(Object key, long time, TimeUnit timeunit) {
            return this.mapProxy.tryLock(key, time, timeunit);
        }

        public void unlock(Object key) {
            this.mapProxy.unlock(key);
        }

        public boolean lockMap(long time, TimeUnit timeunit) {
            return this.mapProxy.lockMap(time, timeunit);
        }

        public void unlockMap() {
            this.mapProxy.unlockMap();
        }

        public LocalMapStats getLocalMultiMapStats() {
            LocalMapStats localMapStats = this.mapProxy.getLocalMapStats();
            return localMapStats;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }
}

