/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.core.Member;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.management.ConnectionInfo;
import com.hazelcast.impl.management.LockInfo;
import com.hazelcast.impl.partition.MigratingPartition;
import com.hazelcast.impl.partition.PartitionInfo;
import com.hazelcast.impl.partition.PartitionRuntimeState;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.Clock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterRuntimeState
extends PartitionRuntimeState
implements DataSerializable {
    private static final int LOCK_MAX_SIZE = 100;
    private int localMemberIndex;
    private Collection<ConnectionInfo> connectionInfos = new LinkedList<ConnectionInfo>();
    private List<LockInfo> lockInfos = new ArrayList<LockInfo>();
    private int lockTotalNum = 0;
    private MigratingPartition migratingPartition;

    public ClusterRuntimeState() {
    }

    public ClusterRuntimeState(Collection<Member> members, PartitionInfo[] partitions, MigratingPartition migratingPartition, Map<Address, Connection> connections, Collection<Record> lockedRecords) {
        HashMap<Address, Integer> addressIndexes = new HashMap<Address, Integer>(members.size());
        int memberIndex = 0;
        for (Member member : members) {
            MemberImpl memberImpl = (MemberImpl)member;
            this.addMemberInfo(new MemberInfo(memberImpl.getAddress(), memberImpl.getNodeType(), member.getUuid()), addressIndexes, memberIndex);
            if (!member.localMember()) {
                Connection conn = connections.get(memberImpl.getAddress());
                ConnectionInfo connectionInfo = conn != null ? new ConnectionInfo(memberIndex, conn.live(), conn.lastReadTime(), conn.lastWriteTime()) : new ConnectionInfo(memberIndex, false, 0L, 0L);
                this.connectionInfos.add(connectionInfo);
            } else {
                this.localMemberIndex = memberIndex;
            }
            ++memberIndex;
        }
        this.setPartitions(partitions, addressIndexes);
        this.setLocks(lockedRecords, addressIndexes);
        this.migratingPartition = migratingPartition;
    }

    private void setLocks(Collection<Record> lockedRecords, Map<Address, Integer> addressIndexes) {
        long now = Clock.currentTimeMillis();
        for (Record record : lockedRecords) {
            if (!record.isActive() || !record.isValid(now) || !record.isLocked()) continue;
            Address owner = record.getLockAddress();
            Integer index = addressIndexes.get(owner);
            if (index == null) {
                index = -1;
            }
            this.lockInfos.add(new LockInfo(record.getName(), String.valueOf(record.getKey()), record.getLockAcquireTime(), index, record.getScheduledActionCount()));
        }
        this.lockTotalNum = this.lockInfos.size();
        Collections.sort(this.lockInfos, new Comparator<LockInfo>(){

            @Override
            public int compare(LockInfo o1, LockInfo o2) {
                int comp1 = Integer.valueOf(o2.getWaitingThreadCount()).compareTo(o1.getWaitingThreadCount());
                if (comp1 == 0) {
                    return Long.valueOf(o1.getAcquireTime()).compareTo(o2.getAcquireTime());
                }
                return comp1;
            }
        });
        this.lockInfos = this.lockInfos.subList(0, Math.min(100, this.lockInfos.size()));
    }

    public MemberInfo getMember(int index) {
        return (MemberInfo)this.members.get(index);
    }

    public Collection<ConnectionInfo> getConnectionInfos() {
        return this.connectionInfos;
    }

    public MemberInfo getLocalMember() {
        return (MemberInfo)this.members.get(this.localMemberIndex);
    }

    public Collection<LockInfo> getLockInfos() {
        return this.lockInfos;
    }

    public int getLockTotalNum() {
        return this.lockTotalNum;
    }

    public MigratingPartition getMigratingPartition() {
        return this.migratingPartition;
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.localMemberIndex = in.readInt();
        this.lockTotalNum = in.readInt();
        boolean hasMigratingPartition = in.readBoolean();
        if (hasMigratingPartition) {
            this.migratingPartition = new MigratingPartition();
            this.migratingPartition.readData(in);
        }
        super.readData(in);
        int size = this.members.size() - 1;
        for (int i = 0; i < size; ++i) {
            ConnectionInfo connectionInfo = new ConnectionInfo();
            connectionInfo.readData(in);
            this.connectionInfos.add(connectionInfo);
        }
        int lockSize = in.readInt();
        for (int i = 0; i < lockSize; ++i) {
            LockInfo lockInfo = new LockInfo();
            lockInfo.readData(in);
            this.lockInfos.add(lockInfo);
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.localMemberIndex);
        out.writeInt(this.lockTotalNum);
        boolean hasMigratingPartition = this.migratingPartition != null;
        out.writeBoolean(hasMigratingPartition);
        if (hasMigratingPartition) {
            this.migratingPartition.writeData(out);
        }
        super.writeData(out);
        for (ConnectionInfo info : this.connectionInfos) {
            info.writeData(out);
        }
        int lockSize = this.lockInfos.size();
        out.writeInt(lockSize);
        for (LockInfo lockInfo : this.lockInfos) {
            lockInfo.writeData(out);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClusterRuntimeState");
        sb.append("{members=").append(this.members);
        sb.append(", localMember=").append(this.localMemberIndex);
        sb.append(", migratingPartition=").append(this.migratingPartition);
        sb.append(", waitingLockCount=").append(this.lockInfos.size());
        sb.append('}');
        return sb.toString();
    }
}

