/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.impl.management.ClusterServiceCallable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockInformationCallable
extends ClusterServiceCallable
implements Callable<Map<String, MapLockState>>,
Serializable,
HazelcastInstanceAware {
    @Override
    public Map<String, MapLockState> call() throws Exception {
        String globalLockMapName = "__hz_Locks";
        final ArrayList<String> mapNames = new ArrayList<String>();
        mapNames.add("__hz_Locks");
        for (Instance instance : this.hazelcastInstance.getInstances()) {
            if (!instance.getInstanceType().isMap()) continue;
            IMap imap = (IMap)instance;
            mapNames.add(imap.getName());
        }
        final ConcurrentHashMap<String, MapLockState> lockInformation = new ConcurrentHashMap<String, MapLockState>();
        this.getClusterService().enqueueAndWait(new Processable(){

            public void process() {
                for (String mapName : mapNames) {
                    CMap cmap = LockInformationCallable.this.getCMap(mapName);
                    HashMap<Object, DistributedLock> lockOwners = new HashMap<Object, DistributedLock>();
                    HashMap<Object, DistributedLock> lockRequested = new HashMap<Object, DistributedLock>();
                    cmap.collectScheduledLocks(lockOwners, lockRequested);
                    MapLockState mapLockState = new MapLockState();
                    mapLockState.setLockOwners(lockOwners);
                    mapLockState.setLockRequested(lockRequested);
                    mapLockState.setGlobalLock(mapName.equals("__hz_Locks"));
                    mapLockState.setMapName(mapName);
                    lockInformation.put(mapName, mapLockState);
                }
            }
        }, 5);
        return lockInformation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapLockState
    implements Serializable {
        private boolean globalLock = false;
        private Map<Object, DistributedLock> lockOwners;
        private Map<Object, DistributedLock> lockRequested;
        private String mapName;

        public boolean isGlobalLock() {
            return this.globalLock;
        }

        public void setGlobalLock(boolean globalLock) {
            this.globalLock = globalLock;
        }

        public Map<Object, DistributedLock> getLockOwners() {
            return this.lockOwners;
        }

        public void setLockOwners(Map<Object, DistributedLock> lockOwners) {
            this.lockOwners = lockOwners;
        }

        public Map<Object, DistributedLock> getLockRequested() {
            return this.lockRequested;
        }

        public void setLockRequested(Map<Object, DistributedLock> lockRequested) {
            this.lockRequested = lockRequested;
        }

        public String getMapName() {
            return this.mapName;
        }

        public void setMapName(String mapName) {
            this.mapName = mapName;
        }
    }
}

