/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.jmx.AbstractMBean;
import com.hazelcast.jmx.JMXAttribute;
import com.hazelcast.jmx.JMXDescription;
import com.hazelcast.jmx.JMXOperation;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.jmx.MapEntryMBean;
import com.hazelcast.jmx.ObjectNameSpec;
import com.hazelcast.query.SqlPredicate;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JMXDescription(value="A distributed Map")
public class MapMBean
extends AbstractMBean<IMap> {
    protected EntryListener listener;

    public MapMBean(IMap managedObject, ManagementService managementService) {
        super(managedObject, managementService);
    }

    @Override
    public ObjectNameSpec getNameSpec() {
        return this.getParentName().getNested("Map", this.getName());
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        if (!registrationDone.booleanValue()) {
            return;
        }
        if (this.managementService.showDetails()) {
            this.listener = new EntryListener(){

                public void entryAdded(EntryEvent event) {
                    MapMBean.this.addEntry(event.getKey());
                }

                public void entryRemoved(EntryEvent event) {
                    MapMBean.this.removeEntry(event.getKey());
                }

                public void entryUpdated(EntryEvent event) {
                }

                public void entryEvicted(EntryEvent event) {
                    this.entryRemoved(event);
                }
            };
            ((IMap)this.getManagedObject()).addEntryListener(this.listener, false);
            for (Object key : ((IMap)this.getManagedObject()).keySet()) {
                this.addEntry(key);
            }
        }
    }

    @Override
    public void preDeregister() throws Exception {
        if (this.listener != null) {
            ((IMap)this.getManagedObject()).removeEntryListener(this.listener);
            this.listener = null;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> entries = mbs.queryNames(MapEntryMBean.buildObjectNameFilter(this.getObjectName()), null);
            for (ObjectName name : entries) {
                if (this.getObjectName().equals(name)) continue;
                mbs.unregisterMBean(name);
            }
        }
    }

    @JMXOperation(value="clear")
    @JMXDescription(value="Clear map")
    public void clear() {
        ((IMap)this.getManagedObject()).clear();
    }

    @JMXOperation(value="values")
    @JMXDescription(value="Values")
    public String values(String query) {
        SqlPredicate predicate = query != null && query.trim().length() > 0 ? new SqlPredicate(query) : null;
        Collection values = predicate != null ? ((IMap)this.getManagedObject()).values(predicate) : ((IMap)this.getManagedObject()).values();
        ArrayList list = new ArrayList(values);
        return ((Object)list).toString();
    }

    @JMXOperation(value="entrySet")
    @JMXDescription(value="EntrySet")
    public String entrySet(String query) {
        SqlPredicate predicate = query != null && query.trim().length() > 0 ? new SqlPredicate(query) : null;
        Set values = predicate != null ? ((IMap)this.getManagedObject()).entrySet(predicate) : ((IMap)this.getManagedObject()).entrySet();
        StringBuilder sb = new StringBuilder().append("{");
        for (Map.Entry entry : values) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("key:").append(entry.getKey()).append(", value:").append(entry.getValue());
        }
        return sb.append("}").toString();
    }

    @JMXAttribute(value="Config")
    @JMXDescription(value="Map configuration")
    public String getConfig() {
        MapConfig config = this.managementService.getInstance().getConfig().getMapConfig(this.getName());
        return config.toString();
    }

    protected void addEntry(Object key) {
        try {
            ObjectName entryName = MapEntryMBean.buildObjectName(this.getObjectName(), key);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (!mbs.isRegistered(entryName)) {
                MapEntryMBean mbean = new MapEntryMBean((IMap)this.getManagedObject(), key);
                mbs.registerMBean(mbean, entryName);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Unable to register MapEntry MBeans", e);
        }
    }

    protected void removeEntry(Object key) {
        try {
            ObjectName entryName = MapEntryMBean.buildObjectName(this.getObjectName(), key);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (mbs.isRegistered(entryName)) {
                mbs.unregisterMBean(entryName);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Unable to unregister MapEntry MBeans", e);
        }
    }

    @JMXAttribute(value="Name")
    @JMXDescription(value="Registration name of the map")
    public String getName() {
        return ((IMap)this.getManagedObject()).getName();
    }

    @JMXAttribute(value="Size")
    @JMXDescription(value="Current size")
    public int getSize() {
        return ((IMap)this.getManagedObject()).size();
    }
}

