/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public class E_LogicalOr
extends ExprFunction2 {
    private static final String functionName = "or";
    private static final String symbol = "||";

    public E_LogicalOr(Expr left, Expr right) {
        super(left, right, functionName, symbol);
    }

    @Override
    public NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        ExprEvalException error = null;
        try {
            NodeValue x = this.getArg1().eval(binding, env);
            if (XSDFuncOp.booleanEffectiveValue(x)) {
                return NodeValue.TRUE;
            }
        }
        catch (ExprEvalException eee) {
            error = eee;
        }
        try {
            NodeValue y = this.getArg2().eval(binding, env);
            if (XSDFuncOp.booleanEffectiveValue(y)) {
                return NodeValue.TRUE;
            }
            if (error != null) {
                throw error;
            }
            return NodeValue.FALSE;
        }
        catch (ExprEvalException eee) {
            if (error != null) {
                throw error;
            }
            throw eee;
        }
    }

    @Override
    public NodeValue eval(NodeValue x, NodeValue y) {
        if (!x.isBoolean()) {
            throw new ExprEvalException("Not a boolean: " + x);
        }
        if (!y.isBoolean()) {
            throw new ExprEvalException("Not a boolean: " + y);
        }
        boolean boolX = x.getBoolean();
        boolean boolY = y.getBoolean();
        return NodeValue.makeBoolean(boolX || boolY);
    }

    @Override
    public Expr copy(Expr e1, Expr e2) {
        return new E_LogicalOr(e1, e2);
    }
}

