/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.update;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.modify.UpdateEngineFactory;
import com.hp.hpl.jena.sparql.modify.UpdateEngineRegistry;
import com.hp.hpl.jena.sparql.modify.UpdateProcessRemote;
import com.hp.hpl.jena.sparql.modify.UpdateProcessRemoteForm;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorBase;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorStreamingBase;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateProcessorStreaming;
import com.hp.hpl.jena.update.UpdateRequest;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;

public class UpdateExecutionFactory {
    public static UpdateProcessor create(Update update2, GraphStore graphStore) {
        return UpdateExecutionFactory.create(new UpdateRequest(update2), graphStore, (Binding)null);
    }

    public static UpdateProcessor create(Update update2, GraphStore graphStore, QuerySolution inputBinding) {
        return UpdateExecutionFactory.create(update2, graphStore, BindingUtils.asBinding(inputBinding));
    }

    public static UpdateProcessor create(Update update2, GraphStore graphStore, Binding inputBinding) {
        return UpdateExecutionFactory.create(new UpdateRequest(update2), graphStore, inputBinding);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore) {
        return UpdateExecutionFactory.make(updateRequest, graphStore, null, null);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore, QuerySolution inputBinding) {
        return UpdateExecutionFactory.create(updateRequest, graphStore, BindingUtils.asBinding(inputBinding));
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore, Binding inputBinding) {
        return UpdateExecutionFactory.make(updateRequest, graphStore, inputBinding, null);
    }

    public static UpdateProcessorStreaming createStreaming(GraphStore graphStore) {
        return UpdateExecutionFactory.makeStreaming(graphStore, null, null);
    }

    public static UpdateProcessorStreaming createStreaming(GraphStore graphStore, QuerySolution inputBinding) {
        return UpdateExecutionFactory.createStreaming(graphStore, BindingUtils.asBinding(inputBinding));
    }

    public static UpdateProcessorStreaming createStreaming(GraphStore graphStore, Binding inputBinding) {
        return UpdateExecutionFactory.makeStreaming(graphStore, inputBinding, null);
    }

    public static UpdateProcessorStreaming createStreaming(GraphStore graphStore, Context context) {
        return UpdateExecutionFactory.makeStreaming(graphStore, null, context);
    }

    public static UpdateProcessorStreaming createStreaming(GraphStore graphStore, QuerySolution inputBinding, Context context) {
        return UpdateExecutionFactory.createStreaming(graphStore, BindingUtils.asBinding(inputBinding), context);
    }

    public static UpdateProcessorStreaming createStreaming(GraphStore graphStore, Binding inputBinding, Context context) {
        return UpdateExecutionFactory.makeStreaming(graphStore, inputBinding, context);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore, Context context) {
        return UpdateExecutionFactory.make(updateRequest, graphStore, null, context);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore, QuerySolution inputBinding, Context context) {
        return UpdateExecutionFactory.create(updateRequest, graphStore, BindingUtils.asBinding(inputBinding), context);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore, Binding inputBinding, Context context) {
        return UpdateExecutionFactory.make(updateRequest, graphStore, inputBinding, context);
    }

    private static UpdateProcessor make(UpdateRequest updateRequest, GraphStore graphStore, Binding inputBinding, Context context) {
        UpdateEngineFactory f;
        if (context == null) {
            context = ARQ.getContext().copy();
            context.putAll(graphStore.getContext());
        }
        if ((f = UpdateEngineRegistry.get().find(graphStore, context)) == null) {
            return null;
        }
        UpdateProcessorBase uProc = new UpdateProcessorBase(updateRequest, graphStore, inputBinding, context, f);
        return uProc;
    }

    private static UpdateProcessorStreaming makeStreaming(GraphStore graphStore, Binding inputBinding, Context context) {
        UpdateEngineFactory f;
        if (context == null) {
            context = ARQ.getContext().copy();
            context.putAll(graphStore.getContext());
        }
        if ((f = UpdateEngineRegistry.get().find(graphStore, context)) == null) {
            return null;
        }
        UpdateProcessorStreamingBase uProc = new UpdateProcessorStreamingBase(graphStore, inputBinding, context, f);
        return uProc;
    }

    public static UpdateProcessor createRemote(Update update2, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemote(new UpdateRequest(update2), remoteEndpoint, null, null);
    }

    public static UpdateProcessor createRemote(Update update2, String remoteEndpoint, HttpAuthenticator authenticator) {
        return UpdateExecutionFactory.createRemote(new UpdateRequest(update2), remoteEndpoint, null, authenticator);
    }

    public static UpdateProcessor createRemote(Update update2, String remoteEndpoint, Context context) {
        return UpdateExecutionFactory.createRemote(new UpdateRequest(update2), remoteEndpoint, context, null);
    }

    public static UpdateProcessor createRemote(Update update2, String remoteEndpoint, Context context, HttpAuthenticator authenticator) {
        return UpdateExecutionFactory.createRemote(new UpdateRequest(update2), remoteEndpoint, context, authenticator);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemote(updateRequest, remoteEndpoint, null, null);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint, HttpAuthenticator authenticator) {
        return UpdateExecutionFactory.createRemote(updateRequest, remoteEndpoint, null, authenticator);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint, Context context) {
        return UpdateExecutionFactory.createRemote(updateRequest, remoteEndpoint, context, null);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint, Context context, HttpAuthenticator authenticator) {
        return new UpdateProcessRemote(updateRequest, remoteEndpoint, context, authenticator);
    }

    public static UpdateProcessor createRemoteForm(Update update2, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemoteForm(update2, remoteEndpoint, null, null);
    }

    public static UpdateProcessor createRemoteForm(Update update2, String remoteEndpoint, HttpAuthenticator authenticator) {
        return UpdateExecutionFactory.createRemoteForm(update2, remoteEndpoint, null, null);
    }

    public static UpdateProcessor createRemoteForm(Update update2, String remoteEndpoint, Context context) {
        return UpdateExecutionFactory.createRemoteForm(new UpdateRequest(update2), remoteEndpoint, null, null);
    }

    public static UpdateProcessor createRemoteForm(Update update2, String remoteEndpoint, Context context, HttpAuthenticator authenticator) {
        return UpdateExecutionFactory.createRemoteForm(new UpdateRequest(update2), remoteEndpoint, null, authenticator);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemoteForm(updateRequest, remoteEndpoint, null, null);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, HttpAuthenticator authenticator) {
        return UpdateExecutionFactory.createRemoteForm(updateRequest, remoteEndpoint, null, authenticator);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, Context context) {
        return new UpdateProcessRemoteForm(updateRequest, remoteEndpoint, context);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, Context context, HttpAuthenticator authenticator) {
        return new UpdateProcessRemoteForm(updateRequest, remoteEndpoint, context, authenticator);
    }
}

