/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper;

import io.dropwizard.Application;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.auth.AuthDynamicFeature;
import io.dropwizard.auth.AuthValueFactoryProvider;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.Authorizer;
import io.dropwizard.auth.CachingAuthenticator;
import io.dropwizard.auth.oauth.OAuthCredentialAuthFilter;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi3.JdbiFactory;
import io.dropwizard.jdbi3.bundles.JdbiExceptionsBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestFilter;
import org.dataone.bookkeeper.api.Customer;
import org.dataone.bookkeeper.config.BookkeeperConfiguration;
import org.dataone.bookkeeper.resources.CustomersResource;
import org.dataone.bookkeeper.resources.OrdersResource;
import org.dataone.bookkeeper.resources.ProductsResource;
import org.dataone.bookkeeper.resources.QuotasResource;
import org.dataone.bookkeeper.resources.UsagesResource;
import org.dataone.bookkeeper.security.DataONEAuthHelper;
import org.dataone.bookkeeper.security.DataONEAuthenticator;
import org.dataone.bookkeeper.security.DataONEAuthorizer;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.jdbi.v3.core.Jdbi;

public class Bookkeeper
extends Application<BookkeeperConfiguration> {
    private Bootstrap<BookkeeperConfiguration> bootstrap;

    public String getName() {
        return "DataONE Bookkeeper";
    }

    public void initialize(Bootstrap<BookkeeperConfiguration> bootstrap) {
        bootstrap.addBundle((ConfiguredBundle)new JdbiExceptionsBundle());
    }

    public void run(BookkeeperConfiguration configuration, Environment environment) throws WebApplicationException {
        JdbiFactory factory = new JdbiFactory();
        Jdbi database = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        DataONEAuthHelper dataoneHelper = new DataONEAuthHelper(environment, database, configuration.getDataONEConfiguration());
        environment.jersey().register((Object)new ProductsResource(database, dataoneHelper));
        environment.jersey().register((Object)new QuotasResource(database, dataoneHelper));
        environment.jersey().register((Object)new UsagesResource(database, dataoneHelper));
        environment.jersey().register((Object)new CustomersResource(database, dataoneHelper));
        environment.jersey().register((Object)new OrdersResource(database, dataoneHelper));
        environment.jersey().register(RolesAllowedDynamicFeature.class);
        DataONEAuthenticator dataoneAuthenticator = new DataONEAuthenticator(dataoneHelper);
        CachingAuthenticator cachingAuthenticator = new CachingAuthenticator(environment.metrics(), (Authenticator)dataoneAuthenticator, configuration.getAuthenticationCachePolicy());
        environment.jersey().register((Object)new AuthDynamicFeature((ContainerRequestFilter)new OAuthCredentialAuthFilter.Builder().setAuthenticator((Authenticator)cachingAuthenticator).setAuthorizer((Authorizer)new DataONEAuthorizer(dataoneHelper)).setPrefix("Bearer").buildAuthFilter()));
        environment.jersey().register((Object)new AuthValueFactoryProvider.Binder(Customer.class));
    }

    public static void main(String[] args) throws Exception {
        new Bookkeeper().run(args);
    }
}

