/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.convert;

import ch.hsr.geohash.GeoHash;
import org.dataone.cn.indexer.convert.IConverter;

public class GeohashConverter
implements IConverter {
    private int length = 9;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public String convert(String latlong) {
        String geohash = null;
        double geohashLat = 0.0;
        double geohashLong = 0.0;
        String[] coords = latlong.split(" ");
        if (coords.length == 2) {
            geohashLat = Double.parseDouble(coords[0]);
            geohashLong = Double.parseDouble(coords[1]);
        } else if (coords.length == 4) {
            double northCoord = Double.parseDouble(coords[0]);
            double southCoord = Double.parseDouble(coords[1]);
            double eastCoord = Double.parseDouble(coords[2]);
            double westCoord = Double.parseDouble(coords[3]);
            if (westCoord == eastCoord || southCoord == northCoord) {
                geohashLat = southCoord;
                geohashLong = westCoord;
            } else {
                if (southCoord > northCoord) {
                    throw new IllegalArgumentException("The southLatitude must not be greater than the northLatitude");
                }
                if (Math.abs(southCoord) > 90.0 || Math.abs(northCoord) > 90.0 || Math.abs(westCoord) > 180.0 || Math.abs(eastCoord) > 180.0) {
                    throw new IllegalArgumentException("The supplied coordinates are out of range.");
                }
                if (eastCoord < westCoord && eastCoord < 0.0) {
                    eastCoord += 360.0;
                }
                double centerLatitude = (southCoord + northCoord) / 2.0;
                double centerLongitude = (westCoord + eastCoord) / 2.0;
                if (centerLongitude > 180.0) {
                    centerLongitude -= 360.0;
                }
                geohashLat = centerLatitude;
                geohashLong = centerLongitude;
            }
        } else {
            return null;
        }
        try {
            geohash = GeoHash.withCharacterPrecision((double)geohashLat, (double)geohashLong, (int)this.length).toBase32();
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        return geohash;
    }
}

