/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.DatabaseAdapter;
import org.ecoinformatics.datamanager.database.DelimitedReader;
import org.ecoinformatics.datamanager.database.HSQLAdapter;
import org.ecoinformatics.datamanager.database.OracleAdapter;
import org.ecoinformatics.datamanager.database.PostgresAdapter;
import org.ecoinformatics.datamanager.database.TableMonitor;
import org.ecoinformatics.datamanager.database.TextComplexFormatDataReader;
import org.ecoinformatics.datamanager.database.TextDataReader;
import org.ecoinformatics.datamanager.download.DataSourceNotFoundException;
import org.ecoinformatics.datamanager.download.DataStorageInterface;
import org.ecoinformatics.datamanager.parser.AttributeList;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.quality.QualityCheck;
import org.ecoinformatics.datamanager.quality.QualityReport;

public class DatabaseLoader
implements DataStorageInterface,
Runnable {
    public static Log log = LogFactory.getLog(DatabaseLoader.class);
    private static TableMonitor tableMonitor = null;
    private PipedInputStream inputStream = null;
    private PipedOutputStream outputStream = new PipedOutputStream();
    private Entity entity = null;
    private DatabaseAdapter databaseAdapter = null;
    private String errorCode = null;
    private boolean completed = false;
    private boolean success = false;
    private Exception exception = null;

    public DatabaseLoader(String dbAdapterName, Entity entity) throws IOException, SQLException {
        this.inputStream = new PipedInputStream();
        this.outputStream.connect(this.inputStream);
        this.entity = entity;
        if (dbAdapterName.equals("PostgresAdapter")) {
            this.databaseAdapter = new PostgresAdapter();
        } else if (dbAdapterName.equals("HSQLAdapter")) {
            this.databaseAdapter = new HSQLAdapter();
        } else if (dbAdapterName.equals("OracleAdapter")) {
            this.databaseAdapter = new OracleAdapter();
        }
        tableMonitor = new TableMonitor(this.databaseAdapter);
    }

    @Override
    public InputStream load(String identifier) throws DataSourceNotFoundException {
        InputStream inputStream = null;
        return inputStream;
    }

    @Override
    public OutputStream startSerialize(String identifier) {
        log.debug((Object)"DatabaseLoader.startSerialize()");
        this.completed = false;
        this.success = false;
        Thread newThread = new Thread(this);
        newThread.start();
        return this.outputStream;
    }

    @Override
    public void finishSerialize(String identifier, String errorCode) {
        this.errorCode = errorCode;
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception e) {
                log.error((Object)("Could not close inputStream in DatabaseLoader.finishSerialize(): " + e.getMessage()));
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (Exception e) {
                log.error((Object)("Could not close outputStream in DatabaseLoader.finishSerialize(): " + e.getMessage()));
            }
        }
        log.debug((Object)"DatabaseLoader.finishSerialize()");
    }

    public PipedInputStream getPipedInputStream() {
        return this.inputStream;
    }

    public PipedOutputStream getPipedOutputStream() {
        return this.outputStream;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DelimitedReader delimitedReader = null;
        QualityCheck dataLoadQualityCheck = null;
        String insertSQL = "";
        Vector<Object> rowVector = new Vector();
        int rowCount = 0;
        if (this.entity == null) {
            this.success = false;
            this.completed = true;
            return;
        }
        String dataLoadIdentifier = "dataLoadStatus";
        QualityCheck dataLoadTemplate = QualityReport.getQualityCheckTemplate(dataLoadIdentifier);
        dataLoadQualityCheck = new QualityCheck(dataLoadIdentifier, dataLoadTemplate);
        AttributeList attributeList = this.entity.getAttributeList();
        String tableName = this.entity.getDBTableName();
        TextDataReader dataReader = null;
        boolean stripHeaderLine = true;
        if (this.inputStream != null) {
            try {
                if (this.entity.isSimpleDelimited()) {
                    delimitedReader = new DelimitedReader(this.inputStream, this.entity.getAttributes().length, this.entity.getFieldDelimiter(), this.entity.getNumHeaderLines(), this.entity.getRecordDelimiter(), this.entity.getNumRecords(), stripHeaderLine);
                    delimitedReader.setEntity(this.entity);
                    delimitedReader.setCollapseDelimiters(this.entity.getCollapseDelimiters());
                    delimitedReader.setNumFooterLines(this.entity.getNumFooterLines());
                    if (this.entity.getQuoteCharacter() != null) {
                        delimitedReader.setQuoteCharacter(this.entity.getQuoteCharacter());
                    }
                    if (this.entity.getLiteralCharacter() != null) {
                        delimitedReader.setLiteralCharacter(this.entity.getLiteralCharacter());
                    }
                    dataReader = delimitedReader;
                } else {
                    dataReader = new TextComplexFormatDataReader(this.inputStream, this.entity, stripHeaderLine);
                }
                rowVector = dataReader.getOneRowDataVector();
            }
            catch (Exception e) {
                log.error((Object)("Exception in DatabaseLoader.run(): " + e.getMessage()));
                if (QualityCheck.shouldRunQualityCheck(this.entity, dataLoadQualityCheck)) {
                    dataLoadQualityCheck.setFailedStatus();
                    dataLoadQualityCheck.setFound("One or more errors occurred during data loading");
                    String explanation = "<![CDATA[" + e.getMessage() + "]]>";
                    dataLoadQualityCheck.setExplanation(explanation);
                    this.entity.addQualityCheck(dataLoadQualityCheck);
                }
                this.success = false;
                this.completed = true;
                this.exception = e;
                return;
            }
            Connection connection = null;
            try {
                String displayRowIdentifier = "displayFirstInsertRow";
                QualityCheck displayRowTemplate = QualityReport.getQualityCheckTemplate(displayRowIdentifier);
                QualityCheck displayRowQualityCheck = new QualityCheck(displayRowIdentifier, displayRowTemplate);
                if (QualityCheck.shouldRunQualityCheck(this.entity, displayRowQualityCheck)) {
                    String foundString = "<![CDATA" + rowVector.toString() + "]>";
                    displayRowQualityCheck.setFound(foundString);
                    displayRowQualityCheck.setStatus(QualityCheck.Status.info);
                    this.entity.addQualityCheck(displayRowQualityCheck);
                }
                if ((connection = DataManager.getConnection()) == null) {
                    this.success = false;
                    this.exception = new Exception("The connection to db is null");
                    this.completed = true;
                    return;
                }
                connection.setAutoCommit(false);
                while (!rowVector.isEmpty()) {
                    insertSQL = this.databaseAdapter.generateInsertSQL(attributeList, tableName, rowVector);
                    if (insertSQL != null) {
                        PreparedStatement statement = connection.prepareStatement(insertSQL);
                        statement.execute();
                        statement.close();
                        ++rowCount;
                    }
                    rowVector = dataReader.getOneRowDataVector();
                }
                connection.commit();
                if (delimitedReader != null) {
                    QualityCheck examineRecordDelimiterTemplate;
                    String examineRecordDelimiterIdentifier;
                    QualityCheck examineRecordDelimiter;
                    QualityCheck tooManyFieldsTemplate;
                    String tooManyFieldsIdentifier;
                    QualityCheck tooManyFieldsCheck;
                    String tooFewFieldsIdentifier = "tooFewFields";
                    QualityCheck tooFewFieldsTemplate = QualityReport.getQualityCheckTemplate(tooFewFieldsIdentifier);
                    QualityCheck tooFewFieldsCheck = new QualityCheck(tooFewFieldsIdentifier, tooFewFieldsTemplate);
                    if (QualityCheck.shouldRunQualityCheck(this.entity, tooFewFieldsCheck) && delimitedReader.getTooFewFieldsCounter() == 0) {
                        tooFewFieldsCheck.setExplanation("");
                        tooFewFieldsCheck.setFound("No errors detected");
                        tooFewFieldsCheck.setStatus(QualityCheck.Status.valid);
                        tooFewFieldsCheck.setSuggestion("");
                        this.entity.addQualityCheck(tooFewFieldsCheck);
                    }
                    if (QualityCheck.shouldRunQualityCheck(this.entity, tooManyFieldsCheck = new QualityCheck(tooManyFieldsIdentifier = "tooManyFields", tooManyFieldsTemplate = QualityReport.getQualityCheckTemplate(tooManyFieldsIdentifier))) && delimitedReader.getTooManyFieldsCounter() == 0) {
                        tooManyFieldsCheck.setExplanation("");
                        tooManyFieldsCheck.setFound("No errors detected");
                        tooManyFieldsCheck.setStatus(QualityCheck.Status.valid);
                        tooManyFieldsCheck.setSuggestion("");
                        this.entity.addQualityCheck(tooManyFieldsCheck);
                    }
                    if (QualityCheck.shouldRunQualityCheck(this.entity, examineRecordDelimiter = new QualityCheck(examineRecordDelimiterIdentifier = "examineRecordDelimiter", examineRecordDelimiterTemplate = QualityReport.getQualityCheckTemplate(examineRecordDelimiterIdentifier))) && !delimitedReader.hasRecordDelimiter()) {
                        String explanation = "No record delimiter was found in the data entity.";
                        if (delimitedReader.exceedsRecordLengthLimit()) {
                            int recordLengthLimit = delimitedReader.getRecordLengthLimit();
                            explanation = String.format("The first %d characters of the data entity were examined and no record delimiter was found matching the record delimiter specified in the metadata.", recordLengthLimit);
                        }
                        examineRecordDelimiter.setExplanation(explanation);
                        examineRecordDelimiter.setFound("No record delimiter was found.");
                        examineRecordDelimiter.setStatus(QualityCheck.Status.error);
                        examineRecordDelimiter.setSuggestion("Check that the record delimiter is specified in the metadata.");
                        this.entity.addQualityCheck(examineRecordDelimiter);
                    }
                }
                if (QualityCheck.shouldRunQualityCheck(this.entity, dataLoadQualityCheck)) {
                    if (rowCount > 0) {
                        dataLoadQualityCheck.setStatus(QualityCheck.Status.valid);
                        dataLoadQualityCheck.setFound("The data table loaded successfully into a database");
                    } else {
                        dataLoadQualityCheck.setFailedStatus();
                        dataLoadQualityCheck.setFound("No data could be loaded into a database");
                    }
                    this.entity.addQualityCheck(dataLoadQualityCheck);
                    String numberOfRecordsIdentifier = "numberOfRecords";
                    QualityCheck numberOfRecordsTemplate = QualityReport.getQualityCheckTemplate(numberOfRecordsIdentifier);
                    QualityCheck numberOfRecordsQualityCheck = new QualityCheck(numberOfRecordsIdentifier, numberOfRecordsTemplate);
                    if (QualityCheck.shouldRunQualityCheck(this.entity, numberOfRecordsQualityCheck)) {
                        int expectedNumberOfRecords = this.entity.getNumRecords();
                        numberOfRecordsQualityCheck.setExpected("" + expectedNumberOfRecords);
                        numberOfRecordsQualityCheck.setFound("" + rowCount);
                        if (expectedNumberOfRecords == rowCount) {
                            numberOfRecordsQualityCheck.setStatus(QualityCheck.Status.valid);
                            numberOfRecordsQualityCheck.setExplanation("The expected number of records (" + rowCount + ") was found in the data table.");
                        } else if (expectedNumberOfRecords != 0 && rowCount == 0) {
                            numberOfRecordsQualityCheck.setFailedStatus();
                            numberOfRecordsQualityCheck.setExplanation("The number of records found in the data table was: " + rowCount + ". Check that a valid record delimiter was specified in the metadata.");
                        } else if (expectedNumberOfRecords < 0) {
                            numberOfRecordsQualityCheck.setStatus(QualityCheck.Status.info);
                            numberOfRecordsQualityCheck.setExplanation("The number of records found in the data table was: " + rowCount + ". There was no 'numberOfRecords' value specified in the EML.");
                        } else {
                            numberOfRecordsQualityCheck.setFailedStatus();
                            numberOfRecordsQualityCheck.setExplanation("The number of records found in the data table (" + rowCount + ") does not match the 'numberOfRecords' value specified in the EML (" + expectedNumberOfRecords + ")");
                        }
                        this.entity.addQualityCheck(numberOfRecordsQualityCheck);
                    }
                }
                this.success = true;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
                e.printStackTrace();
                this.success = false;
                this.exception = e;
                if (QualityCheck.shouldRunQualityCheck(this.entity, dataLoadQualityCheck)) {
                    dataLoadQualityCheck.setFailedStatus();
                    dataLoadQualityCheck.setFound("Error inserting data at row " + (rowCount + 1) + ".");
                    String explanation = "<![CDATA[" + e.getMessage() + "]]>";
                    dataLoadQualityCheck.setExplanation(explanation);
                    this.entity.addQualityCheck(dataLoadQualityCheck);
                }
                try {
                    connection.rollback();
                }
                catch (Exception ee) {
                    log.error((Object)ee.getMessage());
                }
            }
            finally {
                try {
                    connection.setAutoCommit(true);
                }
                catch (Exception ee) {
                    log.error((Object)ee.getMessage());
                }
                DataManager.returnConnection(connection);
            }
        } else {
            log.error((Object)"Input stream is null.");
            this.success = false;
        }
        this.completed = true;
    }

    @Override
    public boolean doesDataExist(String identifier) {
        boolean doesExist = false;
        try {
            String tableName = tableMonitor.identifierToTableName(identifier);
            doesExist = tableMonitor.isTableInDB(tableName);
            if (doesExist) {
                int rowCount = tableMonitor.countRows(tableName);
                doesExist = rowCount > 0;
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return doesExist;
    }

    @Override
    public boolean isCompleted(String identifier) {
        return this.completed || this.doesDataExist(identifier);
    }

    @Override
    public boolean isSuccess(String identifier) {
        return this.success || this.doesDataExist(identifier);
    }

    @Override
    public Exception getException() {
        return this.exception;
    }
}

