/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.quality;

import edu.ucsb.nceas.utilities.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xpath.CachedXPathAPI;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.quality.EntityReport;
import org.ecoinformatics.datamanager.quality.QualityCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QualityReport {
    private static final String INCLUDE_SYSTEM_PATH = "//includeSystem";
    private static final String QUALITY_CHECK_PATH = "//qualityCheck";
    private static HashMap<String, Boolean> includeSystems = new HashMap();
    private static HashMap<String, QualityCheck> qualityCheckTemplates = new HashMap();
    private static Boolean qualityReporting = new Boolean(false);
    private static String qualityReportTemplatePath = null;
    private static String emlDereferencerXSLTPath = null;
    private DataPackage dataPackage;
    private ArrayList<QualityCheck> datasetQualityChecks = new ArrayList();
    private String packageId;

    public QualityReport(DataPackage dataPackage) {
        this.dataPackage = dataPackage;
        if (dataPackage != null) {
            this.packageId = dataPackage.getPackageId();
        }
    }

    private static void addIncludeSystem(String includeSystem) {
        includeSystems.put(includeSystem, new Boolean(true));
    }

    private static void addQualityCheckTemplate(QualityCheck qualityCheck) {
        if (qualityCheck != null) {
            String identifier = qualityCheck.getIdentifier();
            qualityCheckTemplates.put(identifier, qualityCheck);
        }
    }

    public static String getEmlDereferencerXSLTPath() {
        return emlDereferencerXSLTPath;
    }

    public static QualityCheck getQualityCheckTemplate(String identifier) {
        QualityCheck qualityCheckTemplate = qualityCheckTemplates.get(identifier);
        return qualityCheckTemplate;
    }

    public static boolean isIncludeSystem(String system) {
        boolean isIncludeSystem = false;
        if (system != null && includeSystems.get(system) != null) {
            isIncludeSystem = includeSystems.get(system);
        }
        return isIncludeSystem;
    }

    public static Boolean isQualityReporting() {
        return qualityReporting;
    }

    public static void loadTemplate() {
    }

    private static void parseQualityReportTemplate(InputStream inputStream) throws ParserConfigurationException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        CachedXPathAPI xpathapi = new CachedXPathAPI();
        Document document = null;
        try {
            document = documentBuilder.parse(inputStream);
            if (document != null) {
                QualityReport.parseIncludeSystems(document);
                NodeList qualityCheckList = xpathapi.selectNodeList((Node)document, QUALITY_CHECK_PATH);
                if (qualityCheckList != null) {
                    for (int i = 0; i < qualityCheckList.getLength(); ++i) {
                        NodeList referenceNodeList;
                        NodeList suggestionNodeList;
                        NodeList explanationNodeList;
                        NodeList statusNodeList;
                        NodeList foundNodeList;
                        NodeList expectedNodeList;
                        NodeList descriptionNodeList;
                        NodeList nameNodeList;
                        NodeList identifierNodeList;
                        Node statusTypeNode;
                        Node systemNode;
                        QualityCheck qualityCheck = new QualityCheck();
                        Node qualityCheckNode = qualityCheckList.item(i);
                        Node qualityTypeNode = xpathapi.selectSingleNode(qualityCheckNode, "@qualityType");
                        if (qualityTypeNode != null) {
                            String qualityType = qualityTypeNode.getNodeValue();
                            qualityCheck.setQualityType(qualityType);
                        }
                        if ((systemNode = xpathapi.selectSingleNode(qualityCheckNode, "@system")) != null) {
                            String system = systemNode.getNodeValue();
                            qualityCheck.setSystem(system);
                        }
                        if ((statusTypeNode = xpathapi.selectSingleNode(qualityCheckNode, "@statusType")) != null) {
                            String statusType = statusTypeNode.getNodeValue();
                            qualityCheck.setStatusType(statusType);
                        }
                        if ((identifierNodeList = xpathapi.selectNodeList(qualityCheckNode, "identifier")) != null && identifierNodeList.getLength() > 0) {
                            String identifier = identifierNodeList.item(0).getTextContent();
                            qualityCheck.setIdentifier(identifier);
                        }
                        if ((nameNodeList = xpathapi.selectNodeList(qualityCheckNode, "name")) != null && nameNodeList.getLength() > 0) {
                            String name = nameNodeList.item(0).getTextContent();
                            qualityCheck.setName(name);
                        }
                        if ((descriptionNodeList = xpathapi.selectNodeList(qualityCheckNode, "description")) != null && descriptionNodeList.getLength() > 0) {
                            String description = descriptionNodeList.item(0).getTextContent();
                            qualityCheck.setDescription(description);
                        }
                        if ((expectedNodeList = xpathapi.selectNodeList(qualityCheckNode, "expected")) != null && expectedNodeList.getLength() > 0) {
                            String expected = expectedNodeList.item(0).getTextContent();
                            qualityCheck.setExpected(expected);
                        }
                        if ((foundNodeList = xpathapi.selectNodeList(qualityCheckNode, "found")) != null && foundNodeList.getLength() > 0) {
                            String found = foundNodeList.item(0).getTextContent();
                            qualityCheck.setFound(found);
                        }
                        if ((statusNodeList = xpathapi.selectNodeList(qualityCheckNode, "status")) != null && statusNodeList.getLength() > 0) {
                            String status = statusNodeList.item(0).getTextContent();
                            qualityCheck.setStatus(status);
                        }
                        if ((explanationNodeList = xpathapi.selectNodeList(qualityCheckNode, "explanation")) != null && explanationNodeList.getLength() > 0) {
                            String explanation = explanationNodeList.item(0).getTextContent();
                            qualityCheck.setExplanation(explanation);
                        }
                        if ((suggestionNodeList = xpathapi.selectNodeList(qualityCheckNode, "suggestion")) != null && suggestionNodeList.getLength() > 0) {
                            String suggestion = suggestionNodeList.item(0).getTextContent();
                            qualityCheck.setSuggestion(suggestion);
                        }
                        if ((referenceNodeList = xpathapi.selectNodeList(qualityCheckNode, "reference")) != null && referenceNodeList.getLength() > 0) {
                            String reference = referenceNodeList.item(0).getTextContent();
                            qualityCheck.setReference(reference);
                        }
                        QualityReport.addQualityCheckTemplate(qualityCheck);
                    }
                }
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private static void parseIncludeSystems(Document document) {
        CachedXPathAPI xpathapi = new CachedXPathAPI();
        try {
            NodeList includeSystemNodeList = xpathapi.selectNodeList((Node)document, INCLUDE_SYSTEM_PATH);
            if (includeSystemNodeList != null) {
                for (int i = 0; i < includeSystemNodeList.getLength(); ++i) {
                    Node includeSystemNode = includeSystemNodeList.item(i);
                    String includeSystem = includeSystemNode.getTextContent();
                    QualityReport.addIncludeSystem(includeSystem);
                }
            }
        }
        catch (TransformerException e) {
            System.err.println("TransformerException parsing quality report template: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void setQualityReporting(boolean trueOrFalse, String path) {
        Boolean aBoolean = new Boolean(trueOrFalse);
        qualityReporting = aBoolean;
        if (qualityReporting.booleanValue()) {
            qualityReportTemplatePath = path;
            if (qualityReportTemplatePath != null) {
                try {
                    File file = new File(qualityReportTemplatePath);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    QualityReport.parseQualityReportTemplate(fileInputStream);
                }
                catch (FileNotFoundException e) {
                    System.err.println("FileNotFoundException while reading quality report template file: " + e.getMessage());
                    e.printStackTrace();
                }
                catch (ParserConfigurationException e) {
                    System.err.println("ParserConfigurationException while parsing quality report template file: " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                System.err.println("No path was specified for the quality report template file.");
            }
        }
    }

    public static void setEmlDereferencerXSLTPath(String path) {
        emlDereferencerXSLTPath = path;
    }

    private static String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public void addDatasetQualityCheck(QualityCheck qualityCheck) {
        this.datasetQualityChecks.add(qualityCheck);
    }

    public ArrayList<QualityCheck> getDatasetQualityChecks() {
        return this.datasetQualityChecks;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public boolean hasDatasetQualityError() {
        boolean hasError = false;
        for (QualityCheck qualityCheck : this.datasetQualityChecks) {
            if (!qualityCheck.hasErrorStatus()) continue;
            hasError = true;
        }
        return hasError;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public boolean storeQualityReport(File qualityReportFile) throws IOException {
        boolean success = false;
        String qualityReportXML = this.toXML();
        if (qualityReportXML != null) {
            StringBuffer stringBuffer = new StringBuffer(qualityReportXML);
            try {
                FileWriter fileWriter = new FileWriter(qualityReportFile);
                IOUtil.writeToWriter((StringBuffer)stringBuffer, (Writer)fileWriter, (boolean)true);
                success = qualityReportFile != null && qualityReportFile.exists();
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    throw e;
                }
                catch (Throwable throwable) {
                    success = qualityReportFile != null && qualityReportFile.exists();
                    throw throwable;
                }
            }
        }
        return success;
    }

    public String toXML() {
        Entity[] entityArray;
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String dateCreated = dateFormat.format(now);
        String xmlString = null;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuffer.append("<qr:qualityReport\n");
        stringBuffer.append("  xmlns=\"eml://ecoinformatics.org/qualityReport\"\n");
        stringBuffer.append("  xmlns:qr=\"eml://ecoinformatics.org/qualityReport\"\n");
        stringBuffer.append("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        stringBuffer.append("  xsi:schemaLocation=\"eml://ecoinformatics.org/qualityReport http://svn.lternet.edu/svn/NIS/documents/schemas/quality/qualityReportSchema.xsd\"\n");
        stringBuffer.append("  >\n");
        stringBuffer.append("  <creationDate>" + dateCreated + "</creationDate>\n");
        stringBuffer.append("  <packageId>" + this.packageId + "</packageId>\n");
        for (String includeSystem : includeSystems.keySet()) {
            stringBuffer.append("  <includeSystem>" + includeSystem + "</includeSystem>\n");
        }
        stringBuffer.append("  <datasetReport>\n");
        if (this.datasetQualityChecks != null && this.datasetQualityChecks.size() > 0) {
            for (QualityCheck aQualityCheck : this.datasetQualityChecks) {
                String qualityCheckXML = aQualityCheck.toXML();
                stringBuffer.append(qualityCheckXML);
            }
        }
        stringBuffer.append("  </datasetReport>\n");
        if (this.dataPackage != null && (entityArray = this.dataPackage.getEntityList()) != null) {
            for (int i = 0; i < entityArray.length; ++i) {
                EntityReport entityReport;
                Entity entity = entityArray[i];
                if (entity == null || (entityReport = entity.getEntityReport()) == null) continue;
                String entityReportXML = entityReport.toXML();
                stringBuffer.append(entityReportXML);
            }
        }
        stringBuffer.append("</qr:qualityReport>\n");
        xmlString = stringBuffer.toString();
        xmlString = QualityReport.stripNonValidXMLCharacters(xmlString);
        return xmlString;
    }
}

