/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.eml;

import edu.ucsb.nceas.utilities.config.ConfigXML;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXValidate
extends DefaultHandler
implements ErrorHandler {
    private boolean schemavalidate = false;
    public static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";

    public SAXValidate(boolean validateschema) {
        this.schemavalidate = validateschema;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        throw new SAXException("WARNING: " + exception.getMessage());
    }

    public void runTest(Reader xml, String namespaceInDoc) throws IOException, ClassNotFoundException, SAXException, SAXParseException {
        this.runTest(xml, DEFAULT_PARSER, namespaceInDoc);
    }

    public void runTest(Reader xml, String parserName, String namespaceIndoc) throws IOException, ClassNotFoundException, SAXException, SAXParseException {
        String namespaces;
        URL configFile = this.getClass().getResource("/config.xml");
        try {
            ConfigXML config = new ConfigXML(configFile.openStream());
            namespaces = config.get("namespaces", 0);
        }
        catch (Exception e) {
            throw new SAXException("Config file not found: " + e.getMessage());
        }
        System.out.println("Using configured schemaLocation namespaces: " + namespaces);
        this.runTest(xml, parserName, namespaces, namespaceIndoc);
    }

    private void runTest(Reader xml, String parserName, String schemaLocation, String namespaceInDoc) throws IOException, ClassNotFoundException, SAXException, SAXParseException {
        XMLReader parser = parserName.equals("DEFAULT") ? XMLReaderFactory.createXMLReader(DEFAULT_PARSER) : XMLReaderFactory.createXMLReader(parserName);
        parser.setContentHandler(this);
        parser.setErrorHandler(this);
        parser.setFeature("http://xml.org/sax/features/namespaces", true);
        parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        parser.setFeature("http://xml.org/sax/features/validation", true);
        parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", schemaLocation);
        if (this.schemavalidate) {
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            if (namespaceInDoc != null && !namespaceInDoc.equals("eml://ecoinformatics.org/eml-2.0.0") && !namespaceInDoc.equals("eml://ecoinformatics.org/eml-2.0.1")) {
                System.out.println("schema-full-checking");
                parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            }
        }
        parser.parse(new InputSource(xml));
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.out.println("-----------------------------------------------------------------------");
            System.out.println("SAX validate Parser:");
            System.out.println("This parser WILL VALIDATE your eml file against the schema");
            System.out.println("Usage: java org.ecoinformatics.eml.SAXValidate <eml file> [schema -schemaLocation]");
            System.out.println("-----------------------------------------------------------------------");
        }
        if (args.length > 2) {
            System.out.println("Invalid number of arguments.");
            System.exit(0);
        }
        String emlfile = "";
        String schemaLocation = "eml://ecoinformatics.org/eml-2.1.1 ../eml.xsd http://www.xml-cml.org/schema/stmml-1.1 ../stmml.xsd ";
        if (args.length == 2) {
            emlfile = args[0];
            schemaLocation = args[1];
        } else if (args.length == 1) {
            emlfile = args[0];
        } else {
            System.out.println("Usage: java org.ecoinformatics.eml.SAXValidate <eml file> [schema location]");
            System.out.println("  <eml file> = the EML file to parse");
            System.out.println("  <schema location> = use an alternate schema location. The default one is \"eml://ecoinformatics.org/eml-2.1.1 ../eml.xsd\"");
            System.exit(0);
        }
        String namespaceInDoc = null;
        try {
            SAXValidate validator = new SAXValidate(true);
            validator.runTest(new FileReader(emlfile), "DEFAULT", schemaLocation, namespaceInDoc);
            System.out.println(emlfile + " is XML-schema valid. There were no XML errors found in your document.");
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }
}

