/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueueConfig
implements DataSerializable {
    public static final int DEFAULT_MAX_SIZE_PER_JVM = 0;
    private String name;
    private String backingMapRef;
    private int maxSizePerJVM = 0;
    private List<ItemListenerConfig> listenerConfigs;

    public QueueConfig() {
    }

    public QueueConfig(QueueConfig config) {
        this.name = config.name;
        this.backingMapRef = config.backingMapRef;
        this.maxSizePerJVM = config.maxSizePerJVM;
    }

    public String getName() {
        return this.name;
    }

    public QueueConfig setName(String name) {
        this.name = name;
        if (this.backingMapRef == null) {
            this.backingMapRef = "q:" + name;
        }
        return this;
    }

    public int getMaxSizePerJVM() {
        return this.maxSizePerJVM;
    }

    public QueueConfig setMaxSizePerJVM(int maxSizePerJVM) {
        if (maxSizePerJVM < 0) {
            throw new IllegalArgumentException("queue max size per JVM must be positive");
        }
        this.maxSizePerJVM = maxSizePerJVM;
        return this;
    }

    public String getBackingMapRef() {
        return this.backingMapRef;
    }

    public QueueConfig setBackingMapRef(String backingMapRef) {
        this.backingMapRef = backingMapRef;
        return this;
    }

    public QueueConfig addItemListenerConfig(ItemListenerConfig listenerConfig) {
        this.getItemListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<ItemListenerConfig> getItemListenerConfigs() {
        if (this.listenerConfigs == null) {
            this.listenerConfigs = new ArrayList<ItemListenerConfig>();
        }
        return this.listenerConfigs;
    }

    public void setItemListenerConfigs(List<ItemListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
    }

    public boolean isCompatible(QueueConfig queueConfig) {
        if (queueConfig == null) {
            return false;
        }
        return (this.name != null ? this.name.equals(queueConfig.name) : queueConfig.name == null) && this.backingMapRef.equals(queueConfig.backingMapRef) && this.maxSizePerJVM == queueConfig.maxSizePerJVM;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.backingMapRef);
        out.writeInt(this.maxSizePerJVM);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.backingMapRef = in.readUTF();
        this.maxSizePerJVM = in.readInt();
    }

    public String toString() {
        return "QueueConfig [name=" + this.name + ", backingMapRef=" + this.backingMapRef + ", maxSizePerJVM=" + this.maxSizePerJVM + "]";
    }
}

