/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.config.QueueConfig;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.jmx.AbstractMBean;
import com.hazelcast.jmx.JMXAttribute;
import com.hazelcast.jmx.JMXDescription;
import com.hazelcast.jmx.JMXOperation;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.jmx.ObjectNameSpec;
import com.hazelcast.jmx.StatisticsCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JMXDescription(value="A distributed queue")
public class QueueMBean
extends AbstractMBean<IQueue<?>> {
    protected ItemListener listener;
    private StatisticsCollector receivedStats = null;
    private StatisticsCollector servedStats = null;

    public QueueMBean(IQueue<?> queue, ManagementService managementService) {
        super(queue, managementService);
    }

    @Override
    public ObjectNameSpec getNameSpec() {
        return this.getParentName().getNested("Queue", this.getName());
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        if (!registrationDone.booleanValue()) {
            return;
        }
        if (this.managementService.showDetails()) {
            this.receivedStats = ManagementService.newStatisticsCollector();
            this.servedStats = ManagementService.newStatisticsCollector();
            this.listener = new ItemListener(){

                public void itemAdded(ItemEvent item) {
                    QueueMBean.this.receivedStats.addEvent();
                }

                public void itemRemoved(ItemEvent item) {
                    QueueMBean.this.servedStats.addEvent();
                }
            };
            ((IQueue)this.getManagedObject()).addItemListener(this.listener, false);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        if (this.listener != null) {
            ((IQueue)this.getManagedObject()).removeItemListener(this.listener);
            this.listener = null;
        }
        if (this.receivedStats != null) {
            this.receivedStats.destroy();
            this.receivedStats = null;
        }
        if (this.servedStats != null) {
            this.servedStats.destroy();
            this.servedStats = null;
        }
        super.preDeregister();
    }

    @JMXOperation(value="resetStats")
    public void resetStats() {
        if (this.receivedStats != null) {
            this.receivedStats.reset();
        }
        if (this.servedStats != null) {
            this.servedStats.reset();
        }
    }

    @JMXOperation(value="clear")
    public void clear() {
        ((IQueue)this.getManagedObject()).clear();
    }

    @JMXAttribute(value="Name")
    @JMXDescription(value="Registration name of the queue")
    public String getName() {
        return ((IQueue)this.getManagedObject()).getName();
    }

    @JMXAttribute(value="Config")
    @JMXDescription(value="Queue configuration")
    public String getConfig() {
        QueueConfig config = this.managementService.getInstance().getConfig().getQueueConfig(this.getName());
        return config.toString();
    }

    @JMXAttribute(value="Size")
    @JMXDescription(value="Current queue size")
    public int size() {
        return ((IQueue)this.getManagedObject()).size();
    }

    @JMXAttribute(value="ItemsReceived")
    @JMXDescription(value="Total items pushed in the queue since creation")
    public long getItemsReceived() {
        return this.receivedStats.getTotal();
    }

    @JMXAttribute(value="ItemsReceivedLast")
    @JMXDescription(value="Items pushed in the queue in the last second")
    public double getItemsReceivedAvg() {
        return this.receivedStats.getAverage();
    }

    @JMXAttribute(value="ItemsReceivedPeak")
    @JMXDescription(value="Max items pushed in the queue per second")
    public double getItemsReceivedMax() {
        return this.receivedStats.getMax();
    }

    @JMXAttribute(value="ItemsServed")
    @JMXDescription(value="Total items pulled from the queue since creation")
    public long getItemsServed() {
        return this.servedStats.getTotal();
    }

    @JMXAttribute(value="ItemsServedLast")
    @JMXDescription(value="Items pulled from the queue in the last second")
    public double getItemsServedAvg() {
        return this.servedStats.getAverage();
    }

    @JMXAttribute(value="ItemsServedPeak")
    @JMXDescription(value="Max pulled from the queue per second")
    public double getItemsServedMax() {
        return this.servedStats.getMax();
    }
}

