/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.impl.monitor.LocalLockOperationStatsImpl;
import com.hazelcast.impl.monitor.OperationsCounterSupport;
import com.hazelcast.monitor.LocalLockOperationStats;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockOperationsCounter
extends OperationsCounterSupport<LocalLockOperationStats> {
    private static final LocalLockOperationStats empty = new LocalLockOperationStatsImpl();
    private AtomicLong locks = new AtomicLong();
    private AtomicLong unlocks = new AtomicLong();
    private AtomicLong failedLocks = new AtomicLong();

    public LockOperationsCounter() {
    }

    public LockOperationsCounter(long interval) {
        super(interval);
    }

    LockOperationsCounter getAndReset() {
        LockOperationsCounter newOne = new LockOperationsCounter();
        newOne.locks.set(this.locks.getAndSet(0L));
        newOne.unlocks.set(this.unlocks.getAndSet(0L));
        newOne.failedLocks.set(this.failedLocks.getAndSet(0L));
        newOne.startTime = this.startTime;
        this.startTime = newOne.endTime = this.now();
        return newOne;
    }

    public void incrementLocks() {
        this.locks.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementUnlocks() {
        this.unlocks.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementFailedLocks() {
        this.failedLocks.incrementAndGet();
        this.publishSubResult();
    }

    @Override
    LocalLockOperationStats aggregateSubCounterStats() {
        LocalLockOperationStatsImpl stats = new LocalLockOperationStatsImpl();
        stats.periodStart = ((LockOperationsCounter)this.listOfSubCounters.get((int)0)).startTime;
        for (int i = 0; i < this.listOfSubCounters.size(); ++i) {
            LockOperationsCounter sub = (LockOperationsCounter)this.listOfSubCounters.get(i);
            stats.numberOfLocks += sub.locks.get();
            stats.numberOfUnlocks += sub.unlocks.get();
            stats.numberOfFailedLocks += sub.failedLocks.get();
            stats.periodEnd = sub.endTime;
        }
        return stats;
    }

    @Override
    LocalLockOperationStats getThis() {
        LocalLockOperationStatsImpl stats = new LocalLockOperationStatsImpl();
        stats.periodStart = this.startTime;
        stats.numberOfLocks = this.locks.get();
        stats.numberOfUnlocks = this.unlocks.get();
        stats.numberOfFailedLocks = this.failedLocks.get();
        stats.periodEnd = this.now();
        return stats;
    }

    @Override
    LocalLockOperationStats getEmpty() {
        return empty;
    }
}

