/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.writers;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.writers.WriterLib;
import com.hp.hpl.jena.sparql.sse.writers.WriterNode;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.util.Iterator;
import org.apache.jena.atlas.io.IndentedWriter;

public class WriterTable {
    public static void output(IndentedWriter out, Table table, SerializationContext sCxt) {
        WriterLib.start(out, "table", -1);
        WriterNode.outputVars(out, table.getVars(), sCxt);
        out.println();
        WriterTable.outputPlain(out, table, sCxt);
        WriterLib.finish(out, "table");
    }

    public static void outputPlain(IndentedWriter out, Table table, SerializationContext sCxt) {
        QueryIterator qIter = table.iterator(null);
        while (qIter.hasNext()) {
            Binding b = qIter.nextBinding();
            WriterTable.output(out, b, sCxt);
            out.println();
        }
        qIter.close();
    }

    public static void output(IndentedWriter out, Binding binding, SerializationContext sCxt) {
        WriterLib.start(out, "row", -2);
        Iterator<Var> iter = binding.vars();
        while (iter.hasNext()) {
            Var v = iter.next();
            Node n = binding.get(v);
            out.print(" ");
            WriterLib.start2(out);
            out.print(FmtUtils.stringForNode((Node)v, sCxt));
            out.print(" ");
            out.print(FmtUtils.stringForNode(n, sCxt));
            WriterLib.finish2(out);
        }
        WriterLib.finish(out, "row");
    }
}

