/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.MediaRange;
import org.apache.jena.atlas.web.MediaType;

public class AcceptList {
    private List<MediaRange> ranges;
    private static final MediaRangeCompare comparator = new MediaRangeCompare();

    private AcceptList() {
        this.ranges = new ArrayList<MediaRange>();
    }

    public AcceptList(List<MediaRange> mediaRanges) {
        this.ranges = new ArrayList<MediaRange>(mediaRanges);
    }

    public AcceptList(MediaRange ... acceptItems) {
        this.ranges = Arrays.asList(acceptItems);
    }

    public static AcceptList create(MediaType ... acceptItems) {
        AcceptList accepList = new AcceptList();
        for (MediaType mtype : acceptItems) {
            accepList.ranges.add(new MediaRange(mtype));
        }
        return accepList;
    }

    public static AcceptList create(String ... acceptStrings) {
        AcceptList accepList = new AcceptList();
        for (String acceptString : acceptStrings) {
            accepList.ranges.add(new MediaRange(acceptString));
        }
        return accepList;
    }

    public AcceptList(String headerString) {
        try {
            this.ranges = AcceptList.stringToAcceptList(headerString);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            Log.warn(this, "Unrecognized accept string (ignored): " + headerString);
            this.ranges = new ArrayList<MediaRange>();
        }
    }

    private boolean accepts(MediaRange aItem) {
        return this.match(aItem) != null;
    }

    private List<MediaRange> entries() {
        return Collections.unmodifiableList(this.ranges);
    }

    public MediaRange match(MediaType offer) {
        MediaRange choice = null;
        double weight = -1.0;
        int exact = -1;
        for (MediaRange acceptItem : this.ranges) {
            if (!acceptItem.accepts(offer)) continue;
            boolean newChoice = false;
            if (choice == null) {
                newChoice = true;
            } else if (weight < acceptItem.get_q()) {
                newChoice = true;
            } else if (weight == acceptItem.get_q() && exact < acceptItem.subweight()) {
                newChoice = true;
            }
            if (!newChoice) continue;
            choice = acceptItem;
            weight = acceptItem.get_q();
            exact = acceptItem.subweight();
        }
        if (choice == null) {
            return null;
        }
        return choice;
    }

    public static MediaType match(AcceptList proposalList, AcceptList offerList) {
        Object cause = null;
        MediaRange choice = null;
        double weight = -1.0;
        int exactness = -1;
        for (MediaRange offer : offerList.entries()) {
            MediaRange m = proposalList.match(offer);
            if (m == null) continue;
            boolean newChoice = false;
            if (choice == null) {
                newChoice = true;
            } else if (weight < m.get_q()) {
                newChoice = true;
            } else if (weight == m.get_q() && exactness < m.subweight()) {
                newChoice = true;
            }
            if (!newChoice) continue;
            choice = offer;
            weight = m.get_q();
            exactness = m.subweight();
        }
        if (choice == null) {
            return null;
        }
        return new MediaType(choice);
    }

    public MediaRange first() {
        MediaRange choice = null;
        for (MediaRange acceptItem : this.ranges) {
            if (choice != null && choice.get_q() >= acceptItem.get_q()) continue;
            choice = acceptItem;
        }
        return choice;
    }

    public String toString() {
        return this.ranges.toString();
    }

    private static List<MediaRange> stringToAcceptList(String s) {
        String[] x;
        ArrayList<MediaRange> ranges = new ArrayList<MediaRange>();
        if (s == null) {
            return ranges;
        }
        for (String aX : x = s.split(",")) {
            if (aX.equals("")) continue;
            MediaRange mType = new MediaRange(aX);
            ranges.add(mType);
        }
        return ranges;
    }

    private static class MediaRangeCompare
    implements Comparator<MediaRange> {
        private MediaRangeCompare() {
        }

        @Override
        public int compare(MediaRange mType1, MediaRange mType2) {
            int r = Double.compare(mType1.get_q(), mType2.get_q());
            if (r == 0) {
                r = this.subCompare(mType1.getType(), mType2.getType());
            }
            if (r == 0) {
                r = this.subCompare(mType1.getSubType(), mType2.getSubType());
            }
            r = -r;
            return r;
        }

        public int subCompare(String a, String b) {
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            if (a.equals("*") && b.equals("*")) {
                return 0;
            }
            if (a.equals("*")) {
                return -1;
            }
            if (b.equals("*")) {
                return 1;
            }
            return 0;
        }
    }
}

