/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.library.leviathan;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionBase2;
import java.math.BigInteger;

public class pow
extends FunctionBase2 {
    @Override
    public NodeValue exec(NodeValue v1, NodeValue v2) {
        switch (XSDFuncOp.classifyNumeric("pow", v1)) {
            case OP_INTEGER: {
                BigInteger i = v1.getInteger();
                return NodeValue.makeInteger(i.pow(v2.getInteger().intValue()));
            }
            case OP_DECIMAL: {
                double dec = v1.getDecimal().doubleValue();
                return NodeValue.makeDecimal(Math.pow(dec, v2.getDouble()));
            }
            case OP_FLOAT: 
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.pow(v1.getDouble(), v2.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v1);
    }
}

