/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.containers;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.sonatype.guice.bean.binders.ParameterKeys;
import org.sonatype.guice.bean.binders.SpaceModule;
import org.sonatype.guice.bean.binders.WireModule;
import org.sonatype.guice.bean.locators.DefaultBeanLocator;
import org.sonatype.guice.bean.locators.MutableBeanLocator;
import org.sonatype.guice.bean.reflect.BundleClassSpace;

public final class Activator
implements BundleActivator,
BundleTrackerCustomizer,
ServiceTrackerCustomizer {
    static final String BUNDLE_INJECTOR_CLASS_NAME = BundleInjector.class.getName();
    static final MutableBeanLocator LOCATOR = new DefaultBeanLocator();
    private BundleContext bundleContext;
    private ServiceTracker serviceTracker;
    private BundleTracker bundleTracker;

    public void start(BundleContext context) {
        this.bundleContext = context;
        this.serviceTracker = new ServiceTracker(context, BUNDLE_INJECTOR_CLASS_NAME, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        this.bundleTracker = new BundleTracker(context, 32, (BundleTrackerCustomizer)this);
        this.bundleTracker.open();
    }

    public void stop(BundleContext context) {
        this.bundleTracker.close();
        this.serviceTracker.close();
        LOCATOR.clear();
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        String imports = (String)bundle.getHeaders().get("Import-Package");
        if (null == imports || !imports.contains("javax.inject")) {
            return null;
        }
        ServiceReference[] serviceReferences = bundle.getRegisteredServices();
        if (null != serviceReferences) {
            for (ServiceReference ref : serviceReferences) {
                for (String name : (String[])ref.getProperty("objectClass")) {
                    if (!BUNDLE_INJECTOR_CLASS_NAME.equals(name)) continue;
                    return null;
                }
            }
        }
        new BundleInjector(bundle);
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.bundleContext.getService(reference);
        LOCATOR.add(((BundleInjector)service).getInjector());
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        LOCATOR.remove(((BundleInjector)service).getInjector());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BundleProperties
    extends HashMap<String, String> {
        private static final long serialVersionUID = 1L;
        private final transient BundleContext context;

        BundleProperties(BundleContext context) {
            this.context = context;
        }

        @Override
        public String get(Object key) {
            String value = (String)super.get(key);
            return null != value ? value : this.context.getProperty(String.valueOf(key));
        }
    }

    private static final class BundleInjector
    implements Module {
        private static final String[] API = new String[]{BUNDLE_INJECTOR_CLASS_NAME};
        private final Map<String, String> properties;
        private final Injector injector;

        BundleInjector(Bundle bundle) {
            this.properties = new BundleProperties(bundle.getBundleContext());
            BundleClassSpace space = new BundleClassSpace(bundle);
            this.injector = Guice.createInjector((Module[])new Module[]{new WireModule(this, new SpaceModule(space))});
            Hashtable<String, String> metadata = new Hashtable<String, String>();
            ((Dictionary)metadata).put("service.pid", "org.sonatype.inject");
            bundle.getBundleContext().registerService(API, (Object)this, metadata);
        }

        public void configure(Binder binder) {
            binder.bind(ParameterKeys.PROPERTIES).toInstance(this.properties);
            binder.bind(MutableBeanLocator.class).toInstance((Object)LOCATOR);
        }

        public Injector getInjector() {
            return this.injector;
        }
    }
}

