/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.Client;
import com.hazelcast.core.ClientType;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.InstanceEvent;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MessageListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.MultiTask;
import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ClientHandlerService;
import com.hazelcast.impl.ClientRequestHandler;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.DataAwareEntryEvent;
import com.hazelcast.impl.DestroyEndpointThreadsCallable;
import com.hazelcast.impl.Keys;
import com.hazelcast.impl.LifecycleServiceImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.util.ConcurrentHashSet;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientEndpoint
implements EntryListener,
InstanceListener,
MembershipListener,
ConnectionListener,
ClientHandlerService.ClientListener,
Client {
    final Connection conn;
    final Map<Integer, CallContext> callContexts = new HashMap<Integer, CallContext>(100);
    final Map<ITopic, MessageListener<Object>> messageListeners = new HashMap<ITopic, MessageListener<Object>>();
    final List<IMap> listeningMaps = new ArrayList<IMap>();
    final List<MultiMap> listeningMultiMaps = new ArrayList<MultiMap>();
    final List<Map.Entry<IMap, Object>> listeningKeysOfMaps = new ArrayList<Map.Entry<IMap, Object>>();
    final List<Map.Entry<MultiMap, Object>> listeningKeysOfMultiMaps = new ArrayList<Map.Entry<MultiMap, Object>>();
    final Map<IQueue, ItemListener<Object>> queueItemListeners = new ConcurrentHashMap<IQueue, ItemListener<Object>>();
    final Map<Long, DistributedTask> runningExecutorTasks = new ConcurrentHashMap<Long, DistributedTask>();
    final ConcurrentHashSet<ClientRequestHandler> currentRequests = new ConcurrentHashSet();
    final Node node;
    final Map<String, AtomicInteger> attachedSemaphorePermits = new ConcurrentHashMap<String, AtomicInteger>();
    volatile boolean authenticated = false;
    LoginContext loginContext = null;

    ClientEndpoint(Node node, Connection conn) {
        this.node = node;
        this.conn = conn;
    }

    public CallContext getCallContext(int threadId) {
        CallContext context = this.callContexts.get(threadId);
        if (context == null) {
            int locallyMappedThreadId = ThreadContext.get().createNewThreadId();
            context = new CallContext(locallyMappedThreadId, true);
            this.callContexts.put(threadId, context);
        }
        return context;
    }

    public synchronized void addThisAsListener(IMap map, Data key, boolean includeValue) {
        if (!this.listeningMaps.contains(map) && !this.listeningKeyExist(map, (Object)key)) {
            if (key == null) {
                map.addEntryListener(this, includeValue);
            } else {
                map.addEntryListener(this, IOUtil.toObject(key), includeValue);
            }
        }
        if (key == null) {
            this.listeningMaps.add(map);
        } else {
            this.listeningKeysOfMaps.add(new Entry(map, key));
        }
    }

    public synchronized void removeThisListener(IMap map, Data key) {
        ArrayList<Map.Entry<IMap, Object>> entriesToRemove = new ArrayList<Map.Entry<IMap, Object>>();
        if (key == null) {
            this.listeningMaps.remove(map);
        } else {
            for (Map.Entry<IMap, Object> entry : this.listeningKeysOfMaps) {
                if (!entry.getKey().equals(map) || !entry.getValue().equals(key)) continue;
                entriesToRemove.add(entry);
                break;
            }
        }
        this.listeningKeysOfMaps.removeAll(entriesToRemove);
        if (!this.listeningMaps.contains(map) && !this.listeningKeyExist(map, (Object)key)) {
            map.removeEntryListener(this);
        }
    }

    public synchronized void addThisAsListener(MultiMap<Object, Object> multiMap, Data key, boolean includeValue) {
        if (!this.listeningMultiMaps.contains(multiMap) && !this.listeningKeyExist(multiMap, (Object)key)) {
            multiMap.addEntryListener(this, includeValue);
        }
        if (key == null) {
            this.listeningMultiMaps.add(multiMap);
        } else {
            this.listeningKeysOfMultiMaps.add(new Entry(multiMap, key));
        }
    }

    public synchronized void removeThisListener(MultiMap multiMap, Data key) {
        ArrayList<Map.Entry<MultiMap, Object>> entriesToRemove = new ArrayList<Map.Entry<MultiMap, Object>>();
        if (key == null) {
            this.listeningMultiMaps.remove(multiMap);
        } else {
            for (Map.Entry<MultiMap, Object> entry : this.listeningKeysOfMultiMaps) {
                if (!entry.getKey().equals(multiMap) || !entry.getValue().equals(key)) continue;
                entriesToRemove.add(entry);
                break;
            }
        }
        this.listeningKeysOfMultiMaps.removeAll(entriesToRemove);
        if (!this.listeningMultiMaps.contains(multiMap) && !this.listeningKeyExist(multiMap, (Object)key)) {
            multiMap.removeEntryListener(this);
        }
    }

    private boolean listeningKeyExist(IMap map, Object key) {
        for (Map.Entry<IMap, Object> entry : this.listeningKeysOfMaps) {
            if (!entry.getKey().equals(map) || key != null && !entry.getValue().equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean listeningKeyExist(MultiMap map, Object key) {
        for (Map.Entry<MultiMap, Object> entry : this.listeningKeysOfMultiMaps) {
            if (!entry.getKey().equals(map) || key != null && !entry.getValue().equals(key)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.conn.hashCode();
    }

    public void entryAdded(EntryEvent event) {
        this.processEvent(event);
    }

    public void entryEvicted(EntryEvent event) {
        this.processEvent(event);
    }

    public void entryRemoved(EntryEvent event) {
        this.processEvent(event);
    }

    public void entryUpdated(EntryEvent event) {
        this.processEvent(event);
    }

    @Override
    public void instanceCreated(InstanceEvent event) {
        this.processEvent(event);
    }

    @Override
    public void instanceDestroyed(InstanceEvent event) {
        this.processEvent(event);
    }

    @Override
    public void memberAdded(MembershipEvent membershipEvent) {
        this.processEvent(membershipEvent);
    }

    @Override
    public void memberRemoved(MembershipEvent membershipEvent) {
        this.processEvent(membershipEvent);
    }

    private void processEvent(MembershipEvent membershipEvent) {
        Packet packet = this.createMembershipEventPacket(membershipEvent);
        this.sendPacket(packet);
    }

    private void processEvent(InstanceEvent event) {
        Packet packet = this.createInstanceEventPacket(event);
        this.sendPacket(packet);
    }

    private void processEvent(EntryEvent event) {
        Packet packet = this.createEntryEventPacket(event);
        this.sendPacket(packet);
    }

    void sendPacket(Packet packet) {
        if (this.conn != null && this.conn.live()) {
            this.conn.getWriteHandler().enqueueSocketWritable(packet);
        }
    }

    Packet createEntryEventPacket(EntryEvent event) {
        String name;
        Packet packet = new Packet();
        DataAwareEntryEvent dataAwareEntryEvent = (DataAwareEntryEvent)event;
        Data key = dataAwareEntryEvent.getKeyData();
        Data value = null;
        if (dataAwareEntryEvent.getNewValueData() != null) {
            Keys keys = new Keys();
            keys.add(dataAwareEntryEvent.getNewValueData());
            keys.add(dataAwareEntryEvent.getOldValueData());
            value = IOUtil.toData(keys);
        }
        if ((name = dataAwareEntryEvent.getLongName()).startsWith("c:q:l:")) {
            name = name.substring("c:q:".length());
            value = ((DataAwareEntryEvent)event).getNewValueData();
        } else if (name.startsWith("m:s:")) {
            value = ((DataAwareEntryEvent)event).getKeyData();
            key = null;
        }
        packet.set(name, ClusterOperation.EVENT, key, value);
        packet.longValue = event.getEventType().getType();
        return packet;
    }

    Packet createInstanceEventPacket(InstanceEvent event) {
        Packet packet = new Packet();
        packet.set(null, ClusterOperation.EVENT, IOUtil.toData(event.getInstance().getId()), IOUtil.toData(event.getEventType().getId()));
        return packet;
    }

    Packet createMembershipEventPacket(MembershipEvent membershipEvent) {
        Packet packet = new Packet();
        packet.set(null, ClusterOperation.EVENT, IOUtil.toData(membershipEvent.getMember()), IOUtil.toData(membershipEvent.getEventType()));
        return packet;
    }

    @Override
    public void connectionAdded(Connection connection) {
    }

    @Override
    public void connectionRemoved(Connection connection) {
        LifecycleServiceImpl lifecycleService = (LifecycleServiceImpl)this.node.factory.getLifecycleService();
        if (connection.equals(this.conn) && !lifecycleService.paused.get()) {
            this.destroyEndpointThreads();
            this.rollbackTransactions();
            this.removeEntryListeners();
            this.removeEntryListenersWithKey();
            this.removeMessageListeners();
            this.cancelRunningOperations();
            this.releaseAttachedSemaphorePermits();
            this.node.clusterManager.sendProcessableToAll(new ClientHandlerService.CountDownLatchLeave(this.conn.getEndPoint()), true);
            this.node.clientService.remove(this);
        }
    }

    private void destroyEndpointThreads() {
        HashSet<Integer> threadIds = new HashSet<Integer>(this.callContexts.size());
        for (CallContext callContext : this.callContexts.values()) {
            threadIds.add(callContext.getThreadId());
        }
        Set<Member> allMembers = this.node.getClusterImpl().getMembers();
        MultiTask<Boolean> task = new MultiTask<Boolean>(new DestroyEndpointThreadsCallable(this.node.getThisAddress(), threadIds), allMembers);
        this.node.factory.getExecutorService().execute(task);
    }

    private void cancelRunningOperations() {
        for (ClientRequestHandler clientRequestHandler : this.currentRequests) {
            clientRequestHandler.cancel();
        }
        this.currentRequests.clear();
    }

    private void rollbackTransactions() {
        for (CallContext callContext : this.callContexts.values()) {
            ThreadContext.get().setCallContext(callContext);
            if (callContext.getTransaction() == null || callContext.getTransaction().getStatus() != 1) continue;
            callContext.getTransaction().rollback();
        }
    }

    private void removeMessageListeners() {
        for (ITopic topic : this.messageListeners.keySet()) {
            topic.removeMessageListener(this.messageListeners.get(topic));
        }
    }

    private void removeEntryListenersWithKey() {
        for (Map.Entry<IMap, Object> e : this.listeningKeysOfMaps) {
            IMap m = e.getKey();
            m.removeEntryListener(this, e.getValue());
        }
    }

    private void removeEntryListeners() {
        for (IMap map : this.listeningMaps) {
            map.removeEntryListener(this);
        }
    }

    private void releaseAttachedSemaphorePermits() {
        for (Map.Entry<String, AtomicInteger> entry : this.attachedSemaphorePermits.entrySet()) {
            ISemaphore semaphore = this.node.factory.getSemaphore(entry.getKey());
            int permits = entry.getValue().get();
            if (permits > 0) {
                semaphore.releaseDetach(permits);
                continue;
            }
            semaphore.reducePermits(permits);
            semaphore.attach(permits);
        }
    }

    public void attachDetachPermits(String name, int permits) {
        if (this.attachedSemaphorePermits.containsKey(name)) {
            this.attachedSemaphorePermits.get(name).addAndGet(permits);
        } else {
            this.attachedSemaphorePermits.put(name, new AtomicInteger(permits));
        }
    }

    public void storeTask(long callId, DistributedTask task) {
        this.runningExecutorTasks.put(callId, task);
    }

    public void removeTask(long callId) {
        this.runningExecutorTasks.remove(callId);
    }

    public DistributedTask getTask(long taskId) {
        return this.runningExecutorTasks.get(taskId);
    }

    public void addRequest(ClientRequestHandler clientRequestHandler) {
        this.currentRequests.add(clientRequestHandler);
    }

    public void removeRequest(ClientRequestHandler clientRequestHandler) {
        this.currentRequests.remove(clientRequestHandler);
    }

    public void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public Subject getSubject() {
        return this.loginContext != null ? this.loginContext.getSubject() : null;
    }

    public void authenticated() {
        this.authenticated = true;
        this.node.clientService.add(this);
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.conn.getSocketChannelWrapper().socket().getRemoteSocketAddress();
    }

    @Override
    public ClientType getClientType() {
        return ClientType.Native;
    }

    static class Entry
    implements Map.Entry {
        Object key;
        Object value;

        Entry(Object k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object r = this.key;
            this.key = value;
            return r;
        }
    }
}

