/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorWrapper;
import java.util.Iterator;
import java.util.Map;

public class QueryIteratorMapped
extends QueryIteratorWrapper {
    private Map<Var, Var> varMapping;

    public QueryIteratorMapped(QueryIterator qIter, Map<Var, Var> varMapping) {
        super(qIter);
        this.varMapping = varMapping;
    }

    @Override
    protected Binding moveToNextBinding() {
        Binding b = super.moveToNextBinding();
        if (this.varMapping == null) {
            return b;
        }
        BindingMap binding = BindingFactory.create();
        Iterator<Var> vs = b.vars();
        while (vs.hasNext()) {
            Var v = vs.next();
            Node value = b.get(v);
            if (value == null || !this.varMapping.containsKey((Object)v)) continue;
            binding.add(this.varMapping.get((Object)v), value);
        }
        return binding;
    }
}

