/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.optimize.ExprTransformConstantFold;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_BNode;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_Random;
import com.hp.hpl.jena.sparql.expr.E_SameTerm;
import com.hp.hpl.jena.sparql.expr.E_StrUUID;
import com.hp.hpl.jena.sparql.expr.E_UUID;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.expr.ExprFunction0;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprFunctionN;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprTransformCopy;
import com.hp.hpl.jena.sparql.expr.ExprTransformer;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.ExprVisitorBase;
import com.hp.hpl.jena.sparql.expr.ExprWalker;
import com.hp.hpl.jena.sparql.expr.NodeValue;

public class ExprLib {
    private static ExprTransform replaceAgg = new ExprTransformCopy(){

        @Override
        public Expr transform(ExprAggregator eAgg) {
            return eAgg.getAggVar();
        }
    };
    private static ExprVisitor exprVisitorCheckForNonFunctions = new ExprVisitorBase(){

        @Override
        public void visit(ExprFunction0 func) {
            if (func instanceof E_Random || func instanceof E_UUID || func instanceof E_StrUUID) {
                throw new ExprUnstable();
            }
        }

        @Override
        public void visit(ExprFunctionN func) {
            if (func instanceof E_BNode) {
                throw new ExprUnstable();
            }
        }
    };

    public static Expr foldConstants(Expr expr) {
        return ExprTransformer.transform((ExprTransform)new ExprTransformConstantFold(), expr);
    }

    public static Expr replaceAggregateByVariable(Expr expr) {
        return ExprTransformer.transform(replaceAgg, expr);
    }

    public static ExprList replaceAggregateByVariable(ExprList exprs) {
        return ExprTransformer.transform(replaceAgg, exprs);
    }

    public static boolean isAssignmentSafeEquality(Expr expr) {
        return ExprLib.isAssignmentSafeEquality(expr, false, false);
    }

    public static boolean isAssignmentSafeEquality(Expr expr, boolean graphHasStringEquality, boolean graphHasNumercialValueEquality) {
        if (!(expr instanceof E_Equals) && !(expr instanceof E_SameTerm)) {
            return false;
        }
        ExprFunction2 eq = (ExprFunction2)expr;
        Expr left = eq.getArg1();
        Expr right = eq.getArg2();
        Var var = null;
        NodeValue constant = null;
        if (left.isVariable() && right.isConstant()) {
            var = left.asVar();
            constant = right.getConstant();
        } else if (right.isVariable() && left.isConstant()) {
            var = right.asVar();
            constant = left.getConstant();
        }
        if (var == null || constant == null) {
            return false;
        }
        if (!constant.isLiteral()) {
            return true;
        }
        if (expr instanceof E_SameTerm) {
            if (graphHasStringEquality && constant.isString()) {
                return false;
            }
            return !graphHasNumercialValueEquality || !constant.isNumber();
        }
        if (expr instanceof E_Equals) {
            if (!graphHasStringEquality && constant.isString()) {
                return false;
            }
            return graphHasNumercialValueEquality || !constant.isNumber();
        }
        throw new ARQInternalErrorException();
    }

    public static boolean isStable(Expr expr) {
        try {
            ExprWalker.walk(exprVisitorCheckForNonFunctions, expr);
            return true;
        }
        catch (ExprUnstable ex) {
            return false;
        }
    }

    private static class ExprUnstable
    extends ExprException {
        private ExprUnstable() {
        }
    }
}

