/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorFactory;
import java.util.HashMap;
import java.util.Map;

public class AggregateRegistry {
    private static Map<String, AccumulatorFactory> registry = new HashMap<String, AccumulatorFactory>();
    private static Map<String, Node> noGroupValues = new HashMap<String, Node>();

    public static void register(String uri, AccumulatorFactory accFactory) {
        AggregateRegistry.register(uri, accFactory, null);
    }

    public static void register(String uri, AccumulatorFactory accFactory, Node noGroupValue) {
        registry.put(uri, accFactory);
        noGroupValues.put(uri, noGroupValue);
    }

    public static void unregister(String uri) {
        registry.remove(uri);
        noGroupValues.remove(uri);
    }

    public static AccumulatorFactory getAccumulatorFactory(String uri) {
        return registry.get(uri);
    }

    public static Node getNoGroupValue(String uri) {
        return noGroupValues.get(uri);
    }

    public static boolean isRegistered(String uri) {
        return registry.containsKey(uri);
    }
}

