/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunctionN;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.RegexJava;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import java.util.List;
import java.util.regex.Pattern;

public class E_StrReplace
extends ExprFunctionN {
    private static final String symbol = "replace";
    private Pattern pattern = null;

    public E_StrReplace(Expr expr1, Expr expr2, Expr expr3, Expr expr4) {
        super(symbol, expr1, expr2, expr3, expr4);
        if (E_StrReplace.isString(expr2) && (expr4 == null || E_StrReplace.isString(expr4))) {
            int flags = 0;
            if (expr4 != null && expr4.isConstant() && expr4.getConstant().isString()) {
                flags = RegexJava.makeMask(expr4.getConstant().getString());
            }
            this.pattern = Pattern.compile(expr2.getConstant().getString(), flags);
        }
    }

    private static boolean isString(Expr expr) {
        return expr.isConstant() && expr.getConstant().isString();
    }

    @Override
    public NodeValue eval(List<NodeValue> args) {
        if (this.pattern != null) {
            return XSDFuncOp.strReplace(args.get(0), this.pattern, args.get(2));
        }
        if (args.size() == 3) {
            return XSDFuncOp.strReplace(args.get(0), args.get(1), args.get(2));
        }
        return XSDFuncOp.strReplace(args.get(0), args.get(1), args.get(2), args.get(3));
    }

    @Override
    public Expr copy(ExprList newArgs) {
        if (newArgs.size() == 3) {
            return new E_StrReplace(newArgs.get(0), newArgs.get(1), newArgs.get(2), null);
        }
        return new E_StrReplace(newArgs.get(0), newArgs.get(1), newArgs.get(2), newArgs.get(3));
    }
}

