/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Attribute;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Element;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementArray;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementListUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMapUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Text;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Version;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.AttributeLabel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.CacheLabel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Contact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ElementArrayLabel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ElementLabel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ElementListLabel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ElementListUnionLabel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ElementMapLabel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ElementMapUnionLabel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ElementUnionLabel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Label;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.LabelExtractor$LabelBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.LabelGroup;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.LabelKey;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PersistenceException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.TextLabel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.VersionLabel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Format;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.util.Cache;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.util.ConcurrentCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class LabelExtractor {
    private final Cache cache = new ConcurrentCache();
    private final Format format;

    public LabelExtractor(Format format) {
        this.format = format;
    }

    public Label getLabel(Contact contact, Annotation annotation) {
        Object object = this.getKey(contact, annotation);
        LabelGroup labelGroup = this.getGroup(contact, annotation, object);
        if (labelGroup != null) {
            return labelGroup.getPrimary();
        }
        return null;
    }

    public List getList(Contact contact, Annotation annotation) {
        Object object = this.getKey(contact, annotation);
        LabelGroup labelGroup = this.getGroup(contact, annotation, object);
        if (labelGroup != null) {
            return labelGroup.getList();
        }
        return Collections.emptyList();
    }

    private LabelGroup getGroup(Contact contact, Annotation annotation, Object object) {
        LabelGroup labelGroup = (LabelGroup)this.cache.fetch(object);
        if (labelGroup == null) {
            LabelGroup labelGroup2 = this.getLabels(contact, annotation);
            if (labelGroup2 != null) {
                this.cache.cache(object, labelGroup2);
            }
            return labelGroup2;
        }
        return labelGroup;
    }

    private LabelGroup getLabels(Contact contact, Annotation annotation) {
        if (annotation instanceof ElementUnion) {
            return this.getUnion(contact, annotation);
        }
        if (annotation instanceof ElementListUnion) {
            return this.getUnion(contact, annotation);
        }
        if (annotation instanceof ElementMapUnion) {
            return this.getUnion(contact, annotation);
        }
        return this.getSingle(contact, annotation);
    }

    private LabelGroup getSingle(Contact contact, Annotation annotation) {
        Label label = this.getLabel(contact, annotation, null);
        if (label != null) {
            label = new CacheLabel(label);
        }
        return new LabelGroup(label);
    }

    private LabelGroup getUnion(Contact contact, Annotation annotation) {
        Annotation[] annotationArray = this.getAnnotations(annotation);
        if (annotationArray.length > 0) {
            LinkedList<Label> linkedList = new LinkedList<Label>();
            for (Annotation annotation2 : annotationArray) {
                Label label = this.getLabel(contact, annotation, annotation2);
                if (label != null) {
                    label = new CacheLabel(label);
                }
                linkedList.add(label);
            }
            return new LabelGroup(linkedList);
        }
        return null;
    }

    private Annotation[] getAnnotations(Annotation annotation) {
        Class<? extends Annotation> clazz = annotation.annotationType();
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray.length > 0) {
            Method method = methodArray[0];
            Object object = method.invoke((Object)annotation, new Object[0]);
            return (Annotation[])object;
        }
        return new Annotation[0];
    }

    private Label getLabel(Contact contact, Annotation annotation, Annotation annotation2) {
        Constructor constructor = this.getConstructor(annotation);
        if (annotation2 != null) {
            return (Label)constructor.newInstance(contact, annotation, annotation2, this.format);
        }
        return (Label)constructor.newInstance(contact, annotation, this.format);
    }

    private Object getKey(Contact contact, Annotation annotation) {
        return new LabelKey(contact, annotation);
    }

    private Constructor getConstructor(Annotation annotation) {
        LabelExtractor$LabelBuilder labelExtractor$LabelBuilder = this.getBuilder(annotation);
        Constructor constructor = labelExtractor$LabelBuilder.getConstructor();
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    private LabelExtractor$LabelBuilder getBuilder(Annotation annotation) {
        if (annotation instanceof Element) {
            return new LabelExtractor$LabelBuilder(ElementLabel.class, Element.class);
        }
        if (annotation instanceof ElementList) {
            return new LabelExtractor$LabelBuilder(ElementListLabel.class, ElementList.class);
        }
        if (annotation instanceof ElementArray) {
            return new LabelExtractor$LabelBuilder(ElementArrayLabel.class, ElementArray.class);
        }
        if (annotation instanceof ElementMap) {
            return new LabelExtractor$LabelBuilder(ElementMapLabel.class, ElementMap.class);
        }
        if (annotation instanceof ElementUnion) {
            return new LabelExtractor$LabelBuilder(ElementUnionLabel.class, ElementUnion.class, Element.class);
        }
        if (annotation instanceof ElementListUnion) {
            return new LabelExtractor$LabelBuilder(ElementListUnionLabel.class, ElementListUnion.class, ElementList.class);
        }
        if (annotation instanceof ElementMapUnion) {
            return new LabelExtractor$LabelBuilder(ElementMapUnionLabel.class, ElementMapUnion.class, ElementMap.class);
        }
        if (annotation instanceof Attribute) {
            return new LabelExtractor$LabelBuilder(AttributeLabel.class, Attribute.class);
        }
        if (annotation instanceof Version) {
            return new LabelExtractor$LabelBuilder(VersionLabel.class, Version.class);
        }
        if (annotation instanceof Text) {
            return new LabelExtractor$LabelBuilder(TextLabel.class, Text.class);
        }
        throw new PersistenceException("Annotation %s not supported", annotation);
    }
}

