/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.List;

public class ResultSetCheckCondition
implements ResultSet {
    private final ResultSet other;
    private final Condition condition;

    public ResultSetCheckCondition(ResultSet other, QueryExecution qExec) {
        this(other, ResultSetCheckCondition.checkQExec(qExec));
    }

    public ResultSetCheckCondition(ResultSet other, Condition condition) {
        this.other = other;
        this.condition = condition;
    }

    private static Condition checkQExec(final QueryExecution qExec) {
        return new Condition(){

            @Override
            public boolean check() {
                return !qExec.isClosed();
            }
        };
    }

    @Override
    public boolean hasNext() {
        this.check();
        return this.other.hasNext();
    }

    @Override
    public QuerySolution next() {
        this.check();
        return this.other.next();
    }

    @Override
    public void remove() {
        this.check();
        this.other.remove();
    }

    @Override
    public QuerySolution nextSolution() {
        this.check();
        return this.other.nextSolution();
    }

    @Override
    public Binding nextBinding() {
        this.check();
        return this.other.nextBinding();
    }

    @Override
    public int getRowNumber() {
        this.check();
        return this.other.getRowNumber();
    }

    @Override
    public List<String> getResultVars() {
        this.check();
        return this.other.getResultVars();
    }

    @Override
    public Model getResourceModel() {
        this.check();
        return this.other.getResourceModel();
    }

    private final void check() {
        if (!this.condition.check()) {
            throw new ARQException("ResultSet no longer valid (QueryExecution has been closed)");
        }
    }

    static interface Condition {
        public boolean check();
    }
}

