/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.TransformQuadGraph;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarAlloc;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;

public class AlgebraQuad {
    private AlgebraQuad() {
    }

    public static Op quadize(Op op) {
        ArrayDeque<QuadSlot> stack = new ArrayDeque<QuadSlot>();
        QuadSlot qSlot = new QuadSlot(Quad.defaultGraphNodeGenerated, Quad.defaultGraphNodeGenerated);
        stack.push(qSlot);
        Pusher before = new Pusher(stack);
        Popper after = new Popper(stack);
        TransformQuadGraph qg = new TransformQuadGraph(stack, before, after);
        return Transformer.transformSkipService(qg, op, before, after);
    }

    private static class Popper
    extends OpVisitorBase {
        Deque<QuadSlot> stack;

        Popper(Deque<QuadSlot> stack) {
            this.stack = stack;
        }

        @Override
        public void visit(OpGraph opGraph) {
            this.stack.pop();
        }
    }

    private static class Pusher
    extends OpVisitorBase {
        Deque<QuadSlot> stack;
        VarAlloc varAlloc = new VarAlloc("*g");

        Pusher(Deque<QuadSlot> stack) {
            this.stack = stack;
        }

        @Override
        public void visit(OpGraph opGraph) {
            Collection<Var> vars;
            Node gn;
            Object gnQuad = gn = opGraph.getNode();
            if (Var.isVar(gn) && (vars = OpVars.mentionedVars(opGraph.getSubOp())).contains(gn)) {
                gnQuad = this.varAlloc.allocVar();
            }
            this.stack.push(new QuadSlot(gn, (Node)gnQuad));
        }
    }

    static class QuadSlot {
        final Node actualGraphName;
        final Node rewriteGraphName;

        QuadSlot(Node actualGraphName, Node rewriteGraphName) {
            this.actualGraphName = actualGraphName;
            this.rewriteGraphName = rewriteGraphName;
        }

        public String toString() {
            return "actualGraphName=" + this.actualGraphName + " rewriteGraphName=" + this.rewriteGraphName;
        }
    }
}

