/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.block.BlockMgrTracker;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.recordbuffer.RecordBufferPage;
import com.hp.hpl.jena.tdb.base.recordbuffer.RecordBufferPageMgr;
import com.hp.hpl.jena.tdb.base.recordbuffer.RecordRangeIterator;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNode;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNodeMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeRecordsMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import java.util.Iterator;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPlusTree
implements Iterable<Record>,
RangeIndex {
    private static Logger log = LoggerFactory.getLogger(BPlusTree.class);
    private int rootIdx = 0;
    private BPTreeNodeMgr nodeManager;
    private BPTreeRecordsMgr recordsMgr;
    private BPlusTreeParams bpTreeParams;
    private static int SLICE = 10000;

    public static BPlusTree create(BPlusTreeParams params, BlockMgr blkMgrNodes, BlockMgr blkMgrLeaves) {
        BPlusTree bpt = BPlusTree.attach(params, blkMgrNodes, blkMgrLeaves);
        bpt.createIfAbsent();
        return bpt;
    }

    public static BPlusTree attach(BPlusTreeParams params, BlockMgr blkMgrNodes, BlockMgr blkMgrRecords) {
        return new BPlusTree(params, blkMgrNodes, blkMgrRecords);
    }

    public static BPlusTree makeMem(int order, int minRecords, int keyLength, int valueLength) {
        return BPlusTree.makeMem(null, order, minRecords, keyLength, valueLength);
    }

    public static BPlusTree makeMem(String name, int order, int minRecords, int keyLength, int valueLength) {
        int blkSize;
        BPlusTreeParams params = new BPlusTreeParams(order, keyLength, valueLength);
        if (minRecords > 0) {
            int maxRecords = 2 * minRecords;
            blkSize = RecordBufferPage.calcBlockSize(params.getRecordFactory(), maxRecords);
        } else {
            blkSize = params.getCalcBlockSize();
        }
        BlockMgr mgr1 = BlockMgrFactory.createMem(name + "(nodes)", params.getCalcBlockSize());
        BlockMgr mgr2 = BlockMgrFactory.createMem(name + "(records)", blkSize);
        BPlusTree bpTree = BPlusTree.create(params, mgr1, mgr2);
        return bpTree;
    }

    public static BPlusTree addTracking(BPlusTree bpTree) {
        BlockMgr mgr1 = bpTree.getNodeManager().getBlockMgr();
        BlockMgr mgr2 = bpTree.getRecordsMgr().getBlockMgr();
        mgr1 = BlockMgrTracker.track(mgr1);
        mgr2 = BlockMgrTracker.track(mgr2);
        return BPlusTree.attach(bpTree.getParams(), mgr1, mgr2);
    }

    private BPlusTree(BPlusTreeParams params, BlockMgr blkMgrNodes, BlockMgr blkMgrRecords) {
        this.bpTreeParams = params;
        this.nodeManager = new BPTreeNodeMgr(this, blkMgrNodes);
        RecordBufferPageMgr recordPageMgr = new RecordBufferPageMgr(params.getRecordFactory(), blkMgrRecords);
        this.recordsMgr = new BPTreeRecordsMgr(this, recordPageMgr);
    }

    private void createIfAbsent() {
        if (!this.nodeManager.valid(0)) {
            this.startUpdateBlkMgr();
            this.rootIdx = this.nodeManager.createEmptyBPT();
            if (this.rootIdx != 0) {
                throw new InternalError();
            }
            if (BPlusTreeParams.CheckingNode) {
                BPTreeNode root = this.nodeManager.getRead(this.rootIdx, -2);
                root.checkNodeDeep();
                root.release();
            }
            this.nodeManager.getBlockMgr().sync();
            this.recordsMgr.getBlockMgr().sync();
            this.finishUpdateBlkMgr();
        }
    }

    private BPTreeNode getRoot() {
        BPTreeNode root = this.nodeManager.getRoot(this.rootIdx);
        return root;
    }

    private void releaseRoot(BPTreeNode rootNode) {
        rootNode.release();
    }

    private void setRoot(BPTreeNode node) {
    }

    public BPlusTreeParams getParams() {
        return this.bpTreeParams;
    }

    public BPTreeNodeMgr getNodeManager() {
        return this.nodeManager;
    }

    public BPTreeRecordsMgr getRecordsMgr() {
        return this.recordsMgr;
    }

    @Override
    public RecordFactory getRecordFactory() {
        return this.bpTreeParams.recordFactory;
    }

    @Override
    public Record find(Record record) {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRoot();
        Record v = BPTreeNode.search(root, record);
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return v;
    }

    @Override
    public boolean contains(Record record) {
        Record r = this.find(record);
        return r != null;
    }

    @Override
    public Record minKey() {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRoot();
        Record r = root.minRecord();
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return r;
    }

    @Override
    public Record maxKey() {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRoot();
        Record r = root.maxRecord();
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return r;
    }

    @Override
    public boolean add(Record record) {
        return this.addAndReturnOld(record) == null;
    }

    public Record addAndReturnOld(Record record) {
        this.startUpdateBlkMgr();
        BPTreeNode root = this.getRoot();
        Record r = BPTreeNode.insert(root, record);
        if (BPlusTreeParams.CheckingTree) {
            root.checkNodeDeep();
        }
        this.releaseRoot(root);
        this.finishUpdateBlkMgr();
        return r;
    }

    @Override
    public boolean delete(Record record) {
        return this.deleteAndReturnOld(record) != null;
    }

    public Record deleteAndReturnOld(Record record) {
        this.startUpdateBlkMgr();
        BPTreeNode root = this.getRoot();
        Record r = BPTreeNode.delete(root, record);
        if (BPlusTreeParams.CheckingTree) {
            root.checkNodeDeep();
        }
        this.releaseRoot(root);
        this.finishUpdateBlkMgr();
        return r;
    }

    @Override
    public Iterator<Record> iterator() {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRoot();
        Iterator<Record> iter = BPlusTree.iterator(root);
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return iter;
    }

    @Override
    public Iterator<Record> iterator(Record fromRec, Record toRec) {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRoot();
        Iterator<Record> iter = BPlusTree.iterator(root, fromRec, toRec);
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return iter;
    }

    private static Iterator<Record> iterator(BPTreeNode node, Record fromRec, Record toRec) {
        int id = BPTreeNode.recordsPageId(node, fromRec);
        if (id < 0) {
            return Iter.nullIter();
        }
        RecordBufferPageMgr pageMgr = node.getBPlusTree().getRecordsMgr().getRecordBufferPageMgr();
        return RecordRangeIterator.iterator(id, fromRec, toRec, pageMgr);
    }

    private static Iterator<Record> iterator(BPTreeNode node) {
        return BPlusTree.iterator(node, null, null);
    }

    private void startReadBlkMgr() {
        this.nodeManager.startRead();
        this.recordsMgr.startRead();
    }

    private void finishReadBlkMgr() {
        this.nodeManager.finishRead();
        this.recordsMgr.finishRead();
    }

    private void startUpdateBlkMgr() {
        this.nodeManager.startUpdate();
        this.recordsMgr.startUpdate();
    }

    private void finishUpdateBlkMgr() {
        this.nodeManager.finishUpdate();
        this.recordsMgr.finishUpdate();
    }

    @Override
    public boolean isEmpty() {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRoot();
        boolean b = !root.hasAnyKeys();
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return b;
    }

    @Override
    public void clear() {
        Record[] records = new Record[SLICE];
        block0: while (true) {
            Iterator<Record> iter = this.iterator();
            int i = 0;
            for (i = 0; i < SLICE && iter.hasNext(); ++i) {
                Record r;
                records[i] = r = iter.next();
            }
            if (i == 0) break;
            int j = 0;
            while (true) {
                if (j >= i) continue block0;
                this.delete(records[j]);
                records[j] = null;
                ++j;
            }
            break;
        }
    }

    public void sync() {
        if (this.nodeManager.getBlockMgr() != null) {
            this.nodeManager.getBlockMgr().sync();
        }
        if (this.recordsMgr.getBlockMgr() != null) {
            this.recordsMgr.getBlockMgr().sync();
        }
    }

    @Override
    public void close() {
        if (this.nodeManager.getBlockMgr() != null) {
            this.nodeManager.getBlockMgr().close();
        }
        if (this.recordsMgr.getBlockMgr() != null) {
            this.recordsMgr.getBlockMgr().close();
        }
    }

    @Override
    public long size() {
        Iterator<Record> iter = this.iterator();
        return Iter.count(iter);
    }

    @Override
    public void check() {
        this.getRoot().checkNodeDeep();
    }

    public void dump() {
        this.getRoot().dump();
    }

    public void dump(IndentedWriter out) {
        this.getRoot().dump(out);
    }
}

