/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.annotator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.annotator.generator.AnnotationUploader;
import org.dataone.annotator.generator.ManualAnnotationGenerator;
import org.dataone.annotator.ontology.MeasurementTypeGenerator;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;

public class Annotator {
    private static Log log = LogFactory.getLog(Annotator.class);

    private static Options setUpOptions() {
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file for pid listing");
        Option pidFile = OptionBuilder.create((String)"pidfile");
        OptionBuilder.withArgName((String)"nThreads");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given number of threads");
        Option nThreads = OptionBuilder.create((String)"nThreads");
        Option create = new Option("create", "generate the annotations");
        Option createAll = new Option("createAll", "create annotations for ALL content");
        Option remove = new Option("remove", "remove the annotations");
        Option removeAll = new Option("removeAll", "remove ALL annotations");
        Option manual = new Option("manual", "create manual annotations");
        Option types = new Option("types", "create ontology types");
        Options options = new Options();
        options.addOption(create);
        options.addOption(createAll);
        options.addOption(remove);
        options.addOption(removeAll);
        options.addOption(manual);
        options.addOption(types);
        options.addOption(pidFile);
        options.addOption(nThreads);
        return options;
    }

    private static Session setUpSession() {
        X509Certificate certificate = CertificateManager.getInstance().loadCertificate();
        if (certificate == null) {
            return null;
        }
        PrivateKey key = CertificateManager.getInstance().loadKey();
        String subjectDN = CertificateManager.getInstance().getSubjectDN(certificate);
        CertificateManager.getInstance().registerCertificate(subjectDN, certificate, key);
        Session session = new Session();
        Subject subject = new Subject();
        subject.setValue(subjectDN);
        session.setSubject(subject);
        return session;
    }

    public static void main(String[] args) {
        Settings.getConfiguration().setProperty("D1Client.CN_URL", (Object)"https://cn-sandbox-2.test.dataone.org/cn");
        final Session session = Annotator.setUpSession();
        Options options = Annotator.setUpOptions();
        BasicParser parser = new BasicParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
            return;
        }
        List<Object> identifiers = new ArrayList();
        try {
            if (cmd.hasOption("pidfile")) {
                String line;
                if (cmd.hasOption("manual")) {
                    String pidFile = cmd.getOptionValue("pidfile");
                    ManualAnnotationGenerator man = new ManualAnnotationGenerator(session);
                    man.generateAndUpload(pidFile);
                    return;
                }
                if (cmd.hasOption("types")) {
                    String pidFile = cmd.getOptionValue("pidfile");
                    MeasurementTypeGenerator mtg = new MeasurementTypeGenerator();
                    String rdfString = mtg.generateTypes(pidFile);
                    File outputFile = File.createTempFile("generated_types", ".owl");
                    IOUtils.write((String)rdfString, (OutputStream)new FileOutputStream(outputFile));
                    log.debug((Object)("Generated Types file: " + outputFile.getAbsolutePath()));
                    return;
                }
                String pidFile = cmd.getOptionValue("pidfile");
                URL url = new URL(pidFile);
                InputStream inputStream = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    identifiers.add(line);
                }
            }
            if (cmd.hasOption("createAll")) {
                identifiers = Annotator.getAllIdentifiers(session);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final CommandLine cmdRef = cmd;
        if (cmdRef.hasOption("removeAll")) {
            try {
                AnnotationUploader uploader = new AnnotationUploader(session);
                uploader.removeAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        int nThreads = 1;
        if (cmd.hasOption("nThreads")) {
            nThreads = Integer.valueOf(cmd.getOptionValue("nThreads"));
        }
        ExecutorService exec = Executors.newFixedThreadPool(nThreads);
        int size = identifiers.size();
        int segment = size / nThreads;
        int fromIndex = 0;
        int toIndex = 0;
        while (toIndex < identifiers.size()) {
            fromIndex = toIndex;
            toIndex += segment;
            toIndex = Math.min(toIndex, size);
            final List<Object> subList = identifiers.subList(fromIndex, toIndex);
            log.debug((Object)("processing sublist from: " + fromIndex + " to: " + toIndex));
            if (nThreads == 1) {
                try {
                    AnnotationUploader uploader = new AnnotationUploader(session);
                    if (cmdRef.hasOption("create")) {
                        uploader.createAnnotationsFor(subList);
                        continue;
                    }
                    if (cmdRef.hasOption("createAll")) {
                        uploader.createAnnotationsFor(subList);
                        continue;
                    }
                    if (cmdRef.hasOption("remove")) {
                        uploader.removeAnnotationsFor(subList);
                        continue;
                    }
                    if (!cmdRef.hasOption("removeAll")) continue;
                    uploader.removeAll();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        AnnotationUploader uploader = new AnnotationUploader(session);
                        if (cmdRef.hasOption("create")) {
                            uploader.createAnnotationsFor(subList);
                        } else if (cmdRef.hasOption("createAll")) {
                            uploader.createAnnotationsFor(subList);
                        } else if (cmdRef.hasOption("remove")) {
                            uploader.removeAnnotationsFor(subList);
                        } else if (cmdRef.hasOption("removeAll")) {
                            uploader.removeAll();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        exec.shutdown();
        try {
            exec.awaitTermination(3L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    private static List<String> getAllIdentifiers(Session session) {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            String solrQuery = "?q=formatType:METADATA";
            solrQuery = solrQuery + URLEncoder.encode(" -obsoletedBy:*", "UTF-8");
            solrQuery = solrQuery + URLEncoder.encode(" +formatId:eml*", "UTF-8");
            solrQuery = solrQuery + "&fl=id&wt=json&rows=100000";
            log.debug((Object)("solrQuery = " + solrQuery));
            InputStream solrResultStream = D1Client.getCN().query(session, "solr", solrQuery);
            JSONObject solrResults = (JSONObject)JSONValue.parse((InputStream)solrResultStream);
            log.debug((Object)("solrResults = " + solrResults.toJSONString()));
            if (solrResults != null && solrResults.containsKey((Object)"response")) {
                JSONArray solrDocs = (JSONArray)((JSONObject)solrResults.get((Object)"response")).get((Object)"docs");
                log.debug((Object)("solrDocs = " + solrDocs.toJSONString()));
                for (Object solrDoc : solrDocs) {
                    log.debug((Object)("solrDoc = " + solrDoc.toString()));
                    String id = ((JSONObject)solrDoc).get((Object)"id").toString();
                    log.debug((Object)("id = " + id));
                    ids.add(id);
                }
            }
            solrResultStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ids;
    }
}

